/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.xlsx;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.formatters.title.TitleFormatterFacade;
import org.qubership.profiler.io.Call;
import org.qubership.profiler.io.CallFilterer;
import org.qubership.profiler.io.aggregate.Aggregator;
import org.qubership.profiler.io.aggregate.model.AggregateRow;
import org.qubership.profiler.io.xlsx.CallToXLSX;
import org.qubership.profiler.io.xlsx.ICallsToXLSXListener;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AggregateCallsToXLSXListener
implements ICallsToXLSXListener {
    protected CallToXLSX formatter;
    private CallFilterer cf;
    private Aggregator aggregator = new Aggregator();
    private Map<String, Object> formatContext;
    private boolean errorHappened;

    public AggregateCallsToXLSXListener(CallFilterer cf, OutputStream out, Map<String, Object> formatContext) {
        this.cf = cf;
        this.formatContext = formatContext;
        this.formatter = new CallToXLSX(out);
        this.formatter.nextRow();
        this.formatter.addText("Title");
        this.formatter.addText("Count");
        this.formatter.addText("Duration");
        this.formatter.addText("Duration(h)");
        this.formatter.addText("DurationPerExec");
        this.formatter.addText("Duration90thPercentile");
        this.formatter.addText("CpuTime");
        this.formatter.addText("CpuTime(h)");
        this.formatter.addText("CpuTimePerExec");
        this.formatter.addText("Queueing");
        this.formatter.addText("Suspension");
        this.formatter.addText("SuspensionPerExec");
        this.formatter.addText("Memory");
        this.formatter.addText("MemoryGb");
        this.formatter.addText("MemoryPerExec(Mb)");
    }

    @Override
    public void processCalls(String rootReference, ArrayList<Call> calls, List<String> tags, Map<String, ParameterInfoDto> paramInfo, BitSet requiredIds) {
        if (calls.isEmpty()) {
            return;
        }
        Map<String, Integer> tagToIdMap = AggregateCallsToXLSXListener.buildTagToIdMap(tags);
        for (Call call : calls) {
            if (this.cf != null && !this.cf.filter(call)) continue;
            String title = TitleFormatterFacade.formatCommonTitle((String)tags.get(call.method), tagToIdMap, call.params, this.formatContext).getText();
            this.aggregator.processCall(call, title);
        }
    }

    private static Map<String, Integer> buildTagToIdMap(List<String> tags) {
        HashMap<String, Integer> tagToIdMap = new HashMap<String, Integer>(tags.size());
        for (int i = 0; i < tags.size(); ++i) {
            tagToIdMap.put(tags.get(i), i);
        }
        return tagToIdMap;
    }

    @Override
    public void postProcess(String rootReference) {
    }

    @Override
    public void postProcess() {
        if (!this.errorHappened) {
            Collection<AggregateRow> aggregateRows = this.aggregator.finish();
            for (AggregateRow aggregateRow : aggregateRows) {
                this.formatter.nextRow();
                this.formatter.addText(aggregateRow.getTitle());
                this.formatter.addNumber(aggregateRow.getCount());
                this.formatter.addNumber(aggregateRow.getDuration());
                this.formatter.addNumber(aggregateRow.getDurationHours());
                this.formatter.addNumber(aggregateRow.getDurationPerExec());
                this.formatter.addNumber(aggregateRow.getDuration90thPercentile());
                this.formatter.addNumber(aggregateRow.getCpuTime());
                this.formatter.addNumber(aggregateRow.getCpuTimeHours());
                this.formatter.addNumber(aggregateRow.getCpuTimePerExec());
                this.formatter.addNumber(aggregateRow.getQueueing());
                this.formatter.addNumber(aggregateRow.getSuspension());
                this.formatter.addNumber(aggregateRow.getSuspensionPerExec());
                this.formatter.addNumber(aggregateRow.getMemory());
                this.formatter.addNumber(aggregateRow.getMemoryGb());
                this.formatter.addNumber(aggregateRow.getMemoryPerExecMb());
            }
        }
        this.formatter.finish();
    }

    @Override
    public void processError(Throwable ex) {
        this.formatter.nextRow();
        this.formatter.addText(ex.toString());
        this.errorHappened = true;
    }
}

