/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.builders;

import java.util.HashSet;
import org.qubership.profiler.chart.Provider;
import org.qubership.profiler.io.Hotspot;
import org.qubership.profiler.io.SuspendLog;
import org.qubership.profiler.sax.raw.TreeTraceVisitor;
import org.qubership.profiler.sax.values.ValueHolder;

public class TreeBuilderTrace
extends TreeTraceVisitor
implements Provider<Hotspot> {
    private final Hotspot root;
    protected Hotspot[] callTree = new Hotspot[1000];
    protected Hotspot[] stack = new Hotspot[1000];
    public boolean started;
    private final SuspendLog suspendLog;
    private final SuspendLog.SuspendLogCursor suspendCursor;

    public TreeBuilderTrace(Hotspot root, SuspendLog suspendLog) {
        super(1);
        this.root = root;
        this.callTree[0] = root;
        this.stack[0] = new Hotspot(-1);
        this.suspendLog = suspendLog;
        this.suspendCursor = this.suspendLog.cursor();
    }

    protected void ensureStorage(int size) {
        if (size < this.callTree.length) {
            return;
        }
        Hotspot[] tmp = new Hotspot[this.callTree.length * 2];
        System.arraycopy(this.callTree, 0, tmp, 0, this.callTree.length);
        this.callTree = tmp;
        tmp = new Hotspot[this.stack.length * 2];
        System.arraycopy(this.stack, 0, tmp, 0, this.stack.length);
        this.stack = tmp;
    }

    @Override
    public void visitEnter(int methodId, long lastAssemblyId, long lastParentAssemblyId, byte isReactorEndPoint, byte isReactorFrame, long reactorStartTime, int reactorDuration, int blockingOperator, int prevOperation, int currentOperation, int emit) {
        long time = this.getTime();
        int sp = this.getSp();
        Hotspot callTreeParent = this.callTree[sp];
        if (sp != 0) {
            callTreeParent.suspensionTime += this.suspendCursor.moveTo(time);
        } else {
            this.suspendCursor.skipTo(time);
            this.callTree[0].startTime = Math.min(this.callTree[0].startTime, time);
        }
        super.visitEnter(methodId, lastAssemblyId, lastParentAssemblyId, isReactorEndPoint, isReactorFrame, reactorStartTime, reactorDuration, blockingOperator, prevOperation, currentOperation, emit);
        this.ensureStorage(++sp);
        Hotspot orCreateChild = callTreeParent.getOrCreateChild(methodId, lastParentAssemblyId);
        this.propagateReactorParams(lastAssemblyId, lastParentAssemblyId, isReactorEndPoint, isReactorFrame, blockingOperator, prevOperation, currentOperation, emit, orCreateChild);
        this.callTree[sp] = orCreateChild;
        Hotspot hs = this.stack[sp] = new Hotspot(methodId);
        hs.startTime = time;
        hs.endTime = time;
        hs.totalTime = (int)(-time);
        if (reactorDuration != 0 && blockingOperator != 0) {
            orCreateChild.reactorDuration = reactorDuration;
            orCreateChild.reactorStartTime = reactorStartTime;
            hs.reactorDuration = reactorDuration;
            hs.reactorStartTime = reactorStartTime;
        }
    }

    private void propagateReactorParams(long lastAssemblyId, long lastParentAssemblyId, byte isReactorEndPoint, byte isReactorFrame, int blockingOperator, int prevOperation, int currentOperation, int emit, Hotspot orCreateChild) {
        orCreateChild.isReactorEndPoint = isReactorEndPoint;
        orCreateChild.isReactorFrame = isReactorFrame;
        if (lastAssemblyId != 0L) {
            if (orCreateChild.lastAssemblyId == null) {
                orCreateChild.lastAssemblyId = new HashSet<Long>();
            }
            orCreateChild.lastAssemblyId.add(lastAssemblyId);
        }
        if (lastParentAssemblyId != 0L) {
            orCreateChild.lastParentAssemblyId = lastParentAssemblyId;
        }
        if (blockingOperator != 0) {
            orCreateChild.blockingOperator = blockingOperator;
        }
        if (prevOperation != 0) {
            orCreateChild.prevOperation = prevOperation;
        }
        if (currentOperation != 0) {
            orCreateChild.currentOperation = currentOperation;
        }
        if (emit != 0) {
            orCreateChild.emit = emit;
        }
    }

    @Override
    public void visitEnter(int methodId) {
        this.visitEnter(methodId, 0L, 0L, (byte)0, (byte)0, 0L, 0, 0, 0, 0, 0);
    }

    @Override
    public void visitExit() {
        long time = this.getTime();
        int sp = this.getSp();
        Hotspot hs = this.stack[sp];
        hs.suspensionTime += this.suspendCursor.moveTo(time);
        hs.totalTime += (long)((int)time);
        ++hs.count;
        this.callTree[sp].merge(hs);
        super.visitExit();
        if (--sp != 0) {
            return;
        }
        this.callTree[0].endTime = Math.max(this.callTree[0].endTime, time);
        ++this.callTree[0].count;
    }

    @Override
    public void visitLabel(int labelId, ValueHolder value, long assemblyId) {
        this.stack[this.getSp()].tag(0L, labelId, 0, value, assemblyId);
    }

    @Override
    public void visitLabel(int labelId, ValueHolder value) {
        this.visitLabel(labelId, value, 0L);
    }

    @Override
    public void visitEnd() {
        this.root.calculateTotalExecutions();
    }

    @Override
    public Hotspot get() {
        return this.root;
    }
}

