/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.io.BufferedReader;
import java.io.Reader;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.sax.stack.DumpVisitor;
import org.qubership.profiler.sax.stack.DumpsVisitor;
import org.qubership.profiler.threaddump.parser.JRockitThreadParser;
import org.qubership.profiler.threaddump.parser.SunJMXThreadFormatParser;
import org.qubership.profiler.threaddump.parser.SunThreadFormatParser;
import org.qubership.profiler.threaddump.parser.ThreadFormatParser;
import org.qubership.profiler.threaddump.parser.ThreadInfo;
import org.qubership.profiler.util.IOHelper;

public class ThreadDumpReader {
    private final DumpsVisitor dumps;

    public ThreadDumpReader(DumpsVisitor dumps) {
        this.dumps = dumps;
    }

    public void read(Reader reader, String name) {
        BufferedReader br = IOHelper.ensureBuffered((Reader)reader);
        ThreadFormatParser parser = null;
        String s = null;
        ParserState state = ParserState.NOT_STARTED;
        ThreadInfo thread = null;
        DumpVisitor dump = null;
        int maxGarbageLines = 0;
        try {
            while ((s = br.readLine()) != null) {
                if (s.length() == 0) {
                    if (state == ParserState.THREAD_STACK) {
                        dump.visitThread(thread);
                        state = ParserState.IN_DUMP;
                    }
                    if (state != ParserState.OWNABLE_SYNCHRONIZERS) continue;
                    state = ParserState.IN_DUMP;
                    continue;
                }
                char c = s.charAt(0);
                if (state == ParserState.THREAD_STACK) {
                    if (c == '\t' || c == ' ' && s.length() > 10 && (s.charAt(5) == 't' || s.charAt(5) == '-')) {
                        thread.addThreadLine(parser.parseThreadLine(s));
                        continue;
                    }
                    if (c == ' ' && s.startsWith("   java.lang.Thread")) continue;
                    dump.visitThread(thread);
                    state = ParserState.IN_DUMP;
                    continue;
                }
                if (state == ParserState.OWNABLE_SYNCHRONIZERS) {
                    if (s.startsWith("\t-")) continue;
                    state = ParserState.IN_DUMP;
                    continue;
                }
                if (state == ParserState.SMR_INFO) {
                    if (c != '}') continue;
                    state = ParserState.IN_DUMP;
                    continue;
                }
                if (state == ParserState.IN_DUMP) {
                    if (s.startsWith("   Locked ownable synchronizers:")) {
                        state = ParserState.OWNABLE_SYNCHRONIZERS;
                        continue;
                    }
                    if (s.startsWith("Threads class SMR info")) {
                        state = ParserState.SMR_INFO;
                        continue;
                    }
                    if (c == '\"') {
                        state = ParserState.THREAD_STACK;
                        thread = parser.parseThread(s);
                        maxGarbageLines = 0;
                        continue;
                    }
                    if (maxGarbageLines-- > 0) continue;
                    dump.visitEnd();
                }
                if (c == 'F' && s.startsWith("Full thread dump") || c == 'T' && s.startsWith("Thread dump") || c == '=' && s.startsWith("===== FULL THREAD DUMP ===============")) {
                    if (parser == null) {
                        parser = c == 'F' ? new SunThreadFormatParser() : (c == 'T' ? new SunJMXThreadFormatParser() : new JRockitThreadParser());
                    }
                    state = ParserState.IN_DUMP;
                    dump = this.dumps.visitDump();
                    maxGarbageLines = 10;
                    continue;
                }
                state = ParserState.NOT_STARTED;
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorSupervisor.getInstance().warn("Error while parsing thread dump " + name + " at line " + s, t);
        }
        if (state == ParserState.IN_DUMP) {
            dump.visitEnd();
        }
        this.dumps.visitEnd();
    }

    private static enum ParserState {
        NOT_STARTED,
        IN_DUMP,
        THREAD_STACK,
        OWNABLE_SYNCHRONIZERS,
        SMR_INFO;

    }
}

