/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.qubership.profiler.configuration.ParameterInfoDto;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.dump.IDataInputStreamEx;
import org.qubership.profiler.io.ParamReader;
import org.qubership.profiler.io.ParamsPhraseReader;
import org.qubership.profiler.io.ParamsStreamVisitorImpl;
import org.qubership.profiler.util.IOHelper;

public class ParamReaderFile
extends ParamReader {
    File root;

    public ParamReaderFile(File root) {
        this.root = root;
    }

    @Override
    public Map<String, ParameterInfoDto> fillParamInfo(Collection<Throwable> exceptions, String rootReference) {
        HashMap<String, ParameterInfoDto> info = new HashMap<String, ParameterInfoDto>();
        ParamsStreamVisitorImpl visitor = new ParamsStreamVisitorImpl(rootReference);
        try {
            DataInputStreamEx params = this.openDataInputStreamFromAnyDate("params");
            new ParamsPhraseReader((IDataInputStreamEx)params, visitor).parsingPhrases(params.available(), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ParameterInfoDto parameterInfoDto : visitor.getAndCleanParams()) {
            info.put(parameterInfoDto.name, parameterInfoDto);
        }
        return info;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> fillTags(BitSet requredIds, Collection<Throwable> exceptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<String> fillCallsTags(Collection<Throwable> exceptions) {
        String[] tags = new String[1000];
        DataInputStreamEx callsDictIs = null;
        try {
            callsDictIs = DataInputStreamEx.openDataInputStream((File)this.root, (String)"callsDictionary", (int)1);
            while (true) {
                int i = callsDictIs.readVarInt();
                String value = callsDictIs.readString();
                if (i >= tags.length) {
                    String[] newTags = new String[(i + 1) * 2];
                    System.arraycopy(tags, 0, newTags, 0, tags.length);
                    tags = newTags;
                }
                tags[i] = value;
            }
        }
        catch (FileNotFoundException e) {
            exceptions.add(e);
            IOHelper.close((InputStream)callsDictIs);
        }
        catch (EOFException e) {
            IOHelper.close(callsDictIs);
        }
        catch (IOException e) {
            exceptions.add(e);
            {
                catch (Throwable throwable) {
                    IOHelper.close(callsDictIs);
                    throw throwable;
                }
            }
            IOHelper.close((InputStream)callsDictIs);
        }
        return new ArrayList<String>(Arrays.asList(tags));
    }

    public DataInputStreamEx openDataInputStreamAllSequences(String streamName) throws IOException {
        return DataInputStreamEx.openDataInputStreamAllSequences((File)this.root, (String)streamName);
    }

    protected DataInputStreamEx openDataInputStreamFromAnyDate(String streamName) throws IOException {
        File streamRoot = new File(this.root, streamName);
        if (streamRoot.exists()) {
            return DataInputStreamEx.openDataInputStreamAllSequences((File)this.root, (String)streamName);
        }
        File podRoot = this.root.getParentFile().getParentFile().getParentFile().getParentFile();
        LinkedList<File> toCheck = new LinkedList<File>();
        toCheck.add(podRoot);
        while (toCheck.size() > 0) {
            File next = (File)toCheck.poll();
            File[] children = next.listFiles();
            if (children == null) continue;
            for (File child : children) {
                if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                if (child.isDirectory()) {
                    toCheck.add(child);
                    continue;
                }
                String name = child.getName();
                if (name.endsWith(".gz")) {
                    name = name.substring(0, name.length() - 3);
                }
                if (!StringUtils.isNumeric((String)name) || !"params".equals(child.getParentFile().getName())) continue;
                return DataInputStreamEx.openDataInputStreamAllSequences((File)child.getParentFile().getParentFile(), (String)"params");
            }
        }
        throw new RuntimeException("Failed to find params folder within " + podRoot.getCanonicalPath());
    }
}

