/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.exceptions;

import java.util.ArrayList;
import org.qubership.profiler.sax.raw.LoggingSupervisor;

public abstract class ErrorSupervisor {
    private static final ThreadLocal<ArrayList<ErrorSupervisor>> SUPERVISORS = new ThreadLocal<ArrayList<ErrorSupervisor>>(){

        @Override
        protected ArrayList<ErrorSupervisor> initialValue() {
            ArrayList<ErrorSupervisor> state = new ArrayList<ErrorSupervisor>();
            state.add(LoggingSupervisor.INSTANCE);
            return state;
        }
    };

    public static ErrorSupervisor getInstance() {
        ArrayList<ErrorSupervisor> list = SUPERVISORS.get();
        return list.get(list.size() - 1);
    }

    public static void push(ErrorSupervisor next) {
        if (next == null) {
            throw new IllegalArgumentException("ErrorSupervisor must not be null");
        }
        SUPERVISORS.get().add(next);
    }

    public static void pop() {
        ArrayList<ErrorSupervisor> list = SUPERVISORS.get();
        if (list.size() == 1) {
            throw new IllegalStateException("Cannot remove the last supervisor");
        }
        list.remove(list.size() - 1);
    }

    public static <T extends ErrorSupervisor> T findFirst(Class<T> target) {
        ArrayList<ErrorSupervisor> list = SUPERVISORS.get();
        for (ErrorSupervisor supervisor : list) {
            if (!target.isInstance(supervisor)) continue;
            return (T)supervisor;
        }
        return null;
    }

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1, Throwable var2);
}

