/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io.xlsx;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringEscapeUtils;

public class CallToXLSX {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private final OutputStream out;
    private PrintWriter sheetWriter;
    private int rows = 0;
    private String[] colIndexes;
    private List<Object> rowContent = null;

    public CallToXLSX(OutputStream out) {
        this.out = out;
    }

    public void nextRow() {
        if (this.rowContent != null) {
            this.flushRow();
            this.rowContent.clear();
        } else {
            this.rowContent = new ArrayList<Object>();
        }
    }

    public void finish() {
        if (this.rowContent == null) {
            this.rowContent = new ArrayList<Object>();
        }
        this.flushRow();
        CallToXLSX.writeSheetFooter(this.sheetWriter);
        this.sheetWriter.close();
        this.sheetWriter = null;
        this.rows = 0;
    }

    private void flushRow() {
        if (this.sheetWriter == null) {
            ZipOutputStream zout = new ZipOutputStream(this.out);
            try {
                CallToXLSX.addStatic(zout, "docProps/app.xml");
                CallToXLSX.addStatic(zout, "docProps/core.xml");
                CallToXLSX.addStatic(zout, "xl/styles.xml");
                CallToXLSX.addStatic(zout, "xl/workbook.xml");
                CallToXLSX.addStatic(zout, "xl/_rels/workbook.xml.rels");
                CallToXLSX.addStatic(zout, "[Content_Types].xml");
                CallToXLSX.addStatic(zout, "_rels/.rels");
                CallToXLSX.addStatic(zout, "xl/worksheets/_rels/sheet1.xml.rels");
                zout.putNextEntry(new ZipEntry("xl/worksheets/sheet1.xml"));
                this.sheetWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zout, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.colIndexes = CallToXLSX.colIndexes(this.rowContent.size());
            CallToXLSX.writeSheetHeader(this.sheetWriter, this.rowContent.size(), this.colIndexes);
        }
        ++this.rows;
        this.sheetWriter.append("<row r=\"").append(String.valueOf(this.rows)).append("\">");
        for (int col = 0; col < this.rowContent.size(); ++col) {
            Object value = this.rowContent.get(col);
            if (value instanceof Number) {
                this.printColumn(col, "n", "<v>", value.toString(), "</v>");
                continue;
            }
            if (!(value instanceof String)) continue;
            this.printColumn(col, "inlineStr", "<is><t>", StringEscapeUtils.escapeXml((String)((String)value)), "</t></is>");
        }
        this.sheetWriter.append("</row>");
    }

    private void printColumn(int col, String type, String prefix, String content, String suffix) {
        this.sheetWriter.append("<c r=\"").append(this.colIndexes[col]).append(String.valueOf(this.rows)).append("\" t=\"").append(type).append("\">").append(prefix).append(content).append(suffix).append("</c>");
    }

    public void addText(String text) {
        this.rowContent.add(text);
    }

    public void addDate(Date date) {
        this.rowContent.add(this.dateFormat.format(date));
    }

    public void addNumber(Long number) {
        this.rowContent.add(number);
    }

    public void addNumber(Integer number) {
        this.rowContent.add(number);
    }

    public void addNumber(Double number) {
        this.rowContent.add(number);
    }

    public void addHyperlink(String url) {
        this.addText(url);
    }

    public void addEmpty() {
        this.rowContent.add(null);
    }

    private static String[] colIndexes(int numCols) {
        int radix = 26;
        String[] result = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            StringBuilder caption = new StringBuilder();
            int remainder = i;
            boolean aRepresentsOne = false;
            do {
                caption.append((char)(65 + remainder % radix - (aRepresentsOne ? 1 : 0)));
                aRepresentsOne = true;
            } while ((remainder /= radix) > 0);
            result[i] = caption.reverse().toString();
        }
        return result;
    }

    private static void writeSheetHeader(PrintWriter w, int maxCols, String[] colIndex) {
        w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n           xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n    <dimension ref=\"A1:").append(colIndex[maxCols - 1]).append("1").append("\"/>");
        w.append("<sheetViews><sheetView showFormulas=\"false\" showGridLines=\"true\" showRowColHeaders=\"true\" showZeros=\"true\" rightToLeft=\"false\" tabSelected=\"true\" showOutlineSymbols=\"true\" defaultGridColor=\"true\" view=\"normal\" topLeftCell=\"A1\" colorId=\"64\" zoomScale=\"100\" zoomScaleNormal=\"100\" zoomScalePageLayoutView=\"100\" workbookViewId=\"0\"><pane xSplit=\"1\" ySplit=\"1\" topLeftCell=\"B2\" activePane=\"bottomRight\" state=\"frozen\"/></sheetView></sheetViews>");
        w.append("<sheetFormatPr defaultRowHeight=\"15.0\"/>");
        CallToXLSX.printCols(w, maxCols);
        w.append("<sheetData>");
    }

    private static void writeSheetFooter(PrintWriter w) {
        w.append("</sheetData>");
        w.append("<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/></worksheet>");
    }

    private static void printCols(PrintWriter w, int maxCols) {
        w.append("<cols>");
        for (int i = 0; i < maxCols; ++i) {
            w.append("<col min=\"").append(String.valueOf(i + 1)).append("\" max=\"").append(String.valueOf(i + 1)).append("\" width=\"10\" bestFit=\"1\"/>");
        }
        w.append("</cols>");
    }

    private static void addStatic(ZipOutputStream zout, String resource) throws IOException {
        InputStream resourceStream = CallToXLSX.class.getClassLoader().getResourceAsStream("samplexlsx/" + resource);
        if (resourceStream != null) {
            try (BufferedInputStream in = new BufferedInputStream(resourceStream);){
                zout.putNextEntry(new ZipEntry(resource));
                byte[] buffer = new byte[32768];
                int bytesRead = ((InputStream)in).read(buffer);
                while (bytesRead >= 0) {
                    zout.write(buffer, 0, bytesRead);
                    bytesRead = ((InputStream)in).read(buffer);
                }
            }
        } else {
            throw new IOException("Could not find resource '" + resource + "'");
        }
    }
}

