/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.output.layout;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.qubership.profiler.output.layout.Layout;
import org.qubership.profiler.output.layout.LayoutDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePageLayout
extends LayoutDelegate {
    public static final String JAVASCRIPT = "single-page-javascript";
    public static final String HTML = "single-page-html";
    private final Template template;
    protected boolean isWritingHTML;
    private static final Logger LOGGER = LoggerFactory.getLogger(SinglePageLayout.class);

    public static Template getTemplate(String html, Charset charset) throws IOException {
        return new Template(html, charset);
    }

    public SinglePageLayout(Layout parent, Template template) {
        super(parent);
        this.template = template;
    }

    protected void printPageStart() throws IOException {
        this.isWritingHTML = true;
        this.template.appendStart(super.getOutputStream());
    }

    protected void maybeFinishPage() throws IOException {
        if (!this.isWritingHTML) {
            return;
        }
        this.isWritingHTML = false;
        this.template.appendEnd(super.getOutputStream());
    }

    @Override
    public void putNextEntry(String id, String name, String type) throws IOException {
        if (JAVASCRIPT.equals(id)) {
            super.putNextEntry(HTML, name, "text/html");
            this.printPageStart();
            return;
        }
        this.maybeFinishPage();
        super.putNextEntry(id, name, type);
    }

    @Override
    public void close() throws IOException {
        this.maybeFinishPage();
        super.close();
    }

    public static class Template {
        public final byte[] openJs;
        public final byte[] closeJs;

        public Template(String html, Charset charset) {
            int jsEnd = html.lastIndexOf("</script>");
            this.openJs = html.substring(0, jsEnd).getBytes(charset);
            this.closeJs = html.substring(jsEnd).getBytes(charset);
        }

        public void appendStart(OutputStream out) throws IOException {
            out.write(this.openJs);
        }

        public void appendEnd(OutputStream out) throws IOException {
            out.write(this.closeJs);
        }
    }
}

