/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.io.File;
import java.io.IOException;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.ParamReader;
import org.qubership.profiler.io.ParamReaderFactory;
import org.qubership.profiler.sax.raw.ClobReaderFlyweight;
import org.qubership.profiler.sax.raw.ClobReaderFlyweightFile;
import org.qubership.profiler.sax.raw.RepositoryVisitor;
import org.qubership.profiler.sax.raw.SuspendLogVisitor;
import org.qubership.profiler.sax.readers.ProfilerTraceReader;
import org.qubership.profiler.sax.readers.SuspendLogReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class ProfilerTraceReaderFile
extends ProfilerTraceReader {
    @Value(value="${org.qubership.profiler.DUMP_ROOT_LOCATION}")
    File dumpRoot;
    @Autowired
    ParamReaderFactory paramReaderFactory;
    @Autowired
    ApplicationContext context;

    public ProfilerTraceReaderFile() {
    }

    private File dataFolder() {
        return new File(this.dumpRoot, this.rootReference);
    }

    public ProfilerTraceReaderFile(RepositoryVisitor rv, String rootReference) {
        super(rv, rootReference);
    }

    @Override
    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv, long begin, long end) {
        return (SuspendLogReader)this.context.getBean(SuspendLogReader.class, new Object[]{sv, this.dataFolder().getAbsolutePath(), begin, end});
    }

    @Override
    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv) {
        return this.suspendLogReader(sv, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public DataInputStreamEx reopenDataInputStream(DataInputStreamEx oldOne, String streamName, int traceFileIndex) throws IOException {
        return DataInputStreamEx.reopenDataInputStream((DataInputStreamEx)oldOne, (File)this.dataFolder(), (String)streamName, (int)traceFileIndex);
    }

    @Override
    public ClobReaderFlyweight clobReaderFlyweight() {
        ClobReaderFlyweightFile result = new ClobReaderFlyweightFile();
        result.setDataFolder(this.dataFolder());
        return result;
    }

    @Override
    protected ParamReader paramReader() {
        return this.paramReaderFactory.getInstance(this.dataFolder().getAbsolutePath());
    }
}

