/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.io.CallRowid;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.sax.raw.MultiRepositoryVisitor;
import org.qubership.profiler.sax.raw.RepositoryVisitor;
import org.qubership.profiler.sax.raw.TreeRowid;
import org.qubership.profiler.sax.readers.ProfilerTraceReader;
import org.qubership.profiler.sax.readers.ProfilerTraceReaderFactory;
import org.qubership.profiler.timeout.ProfilerTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ProfilerTraceReaderMR {
    private final MultiRepositoryVisitor mrv;
    @Autowired
    ProfilerTraceReaderFactory traceReaderFactory;

    private ProfilerTraceReaderMR() {
        throw new RuntimeException("no-args constructor not supported");
    }

    public ProfilerTraceReaderMR(MultiRepositoryVisitor mrv) {
        this.mrv = mrv;
    }

    public void read(CallRowid[] callIds) {
        this.read(callIds, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public void read(CallRowid[] callIds, long begin, long end) {
        if (callIds.length == 0) {
            return;
        }
        HashMap<String, ArrayList<TreeRowid>> x = new HashMap<String, ArrayList<TreeRowid>>();
        for (CallRowid callId : callIds) {
            ArrayList<TreeRowid> treeRowids = (ArrayList<TreeRowid>)x.get(callId.file);
            if (treeRowids == null) {
                treeRowids = new ArrayList<TreeRowid>();
                x.put(callId.file, treeRowids);
            }
            treeRowids.add(callId.rowid);
        }
        for (Map.Entry entry : x.entrySet()) {
            RepositoryVisitor rv = this.mrv.visitRepository((String)entry.getKey());
            try {
                ProfilerTraceReader reader = this.traceReaderFactory.newTraceReader(rv, (String)entry.getKey());
                reader.read((List)entry.getValue(), begin, end);
            }
            catch (Error | ProfilerTimeoutException e) {
                throw e;
            }
            catch (Throwable t) {
                ErrorSupervisor.getInstance().error("Unable to read " + (String)entry.getKey(), t);
            }
            rv.visitEnd();
        }
        this.mrv.visitEnd();
    }
}

