/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.threaddump.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.qubership.profiler.threaddump.parser.ThreadFormatParser;
import org.qubership.profiler.threaddump.parser.ThreadInfo;

public class ThreaddumpParser {
    static final String SEP = "\\000";

    static String toJString(String x) {
        if (x == null) {
            return "";
        }
        if (x.indexOf(92) != -1) {
            x = x.replaceAll("\\\\", "\\\\\\\\");
        }
        if (x.indexOf(39) != -1) {
            x = x.replaceAll("'", "\\\\'");
        }
        if (x.indexOf(10) != -1) {
            x = x.replaceAll("\n", "\\\\n");
        }
        if (x.indexOf(13) != -1) {
            x = x.replaceAll("\r", "\\\\r");
        }
        if (x.indexOf(13) != -1) {
            x = x.replaceAll("\r", "\\\\r");
        }
        x = x.replace('\u0000', '\u0001');
        return x;
    }

    static class ThreadDumpImpl
    implements ThreadDump {
        String timeBefore;
        String timeAfter;
        List<ThreadInfo> threads = new ArrayList<ThreadInfo>();
        ThreadInfo currentThread;
        String dumpTitle;
        String deadlockInfo;
        String preDumpInfo;
        String postDumpInfo;
        ThreadFormatParser parser;
        LinkedList<Object> standaloneLocks = new LinkedList();
        Collection<Exception> exceptions = new ArrayList<Exception>();
        String raw;
        String srv;
        String os;
        String arch;

        ThreadDumpImpl() {
        }

        @Override
        public void setTitle(String title) {
            this.dumpTitle = title;
        }

        @Override
        public String getTitle() {
            return this.dumpTitle;
        }

        @Override
        public void setServer(String srv, String os, String arch) {
            this.srv = srv;
            this.os = os;
            this.arch = arch;
        }

        @Override
        public void setThreadFormatParser(ThreadFormatParser threadformatparser) {
            this.parser = threadformatparser;
        }

        @Override
        public void setPreDumpInfo(String s) {
            this.preDumpInfo = s;
        }

        @Override
        public void setPostDumpInfo(String s) {
            this.postDumpInfo = s;
        }

        @Override
        public void addThread(String s) {
            this.currentThread = this.parser.parseThread(s);
            this.threads.add(this.currentThread);
        }

        @Override
        public void addThreadLine(String s) {
            ThreadLineInfo threadlineinfo = this.parser.parseThreadLine(s);
            if (threadlineinfo != null) {
                this.currentThread.addThreadLine(threadlineinfo);
            }
        }

        @Override
        public void addDeadLockInfo(String s) {
            this.deadlockInfo = s;
        }

        @Override
        public void addLocks(LinkedList<Object> linkedlist) {
            this.standaloneLocks.addAll(linkedlist);
        }

        public Collection<ThreadInfo> getThreads() {
            return this.threads;
        }

        @Override
        public void addException(Exception e) {
            this.exceptions.add(e);
        }

        public Collection getExceptions() {
            return this.exceptions;
        }

        @Override
        public void setRaw(String raw) {
            this.raw = raw;
        }

        @Override
        public String getRaw() {
            return this.raw;
        }

        @Override
        public StringBuffer toJS(StringBuffer sb) {
            sb.append("new ThreadDump('");
            sb.append(ThreaddumpParser.toJString(this.srv)).append("', '");
            sb.append(ThreaddumpParser.toJString(this.os)).append("', '");
            sb.append(ThreaddumpParser.toJString(this.arch)).append("', '");
            sb.append(ThreaddumpParser.toJString(this.raw));
            sb.append("'\n, [");
            Iterator<ThreadInfo> it = this.threads.iterator();
            while (it.hasNext()) {
                ((JSerializable)it.next()).toJS(sb);
                sb.append(",\n");
            }
            return sb.append("])\n");
        }
    }

    static interface ThreadDump
    extends JSerializable {
        public void addException(Exception var1);

        public Collection<? extends Object> getExceptions();

        public void setThreadFormatParser(ThreadFormatParser var1);

        public void setPreDumpInfo(String var1);

        public void setPostDumpInfo(String var1);

        public Collection<? extends Object> getThreads();

        public void addThread(String var1);

        public void addThreadLine(String var1);

        public void addDeadLockInfo(String var1);

        public void addLocks(LinkedList<Object> var1);

        public void setRaw(String var1);

        public String getRaw();

        public void setServer(String var1, String var2, String var3);

        public void setTitle(String var1);

        public String getTitle();
    }

    public static interface ThreadLineInfo
    extends JSerializable {
        public boolean isMethodLine(String var1, String var2);

        public boolean isLockLine(String var1);
    }

    public static interface JSerializable {
        public StringBuffer toJS(StringBuffer var1);
    }
}

