/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    long pos;
    private final long maxSize;

    public LimitedInputStream(InputStream in, long maxSize) {
        super(in);
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        if (this.pos > this.maxSize) {
            return -1;
        }
        ++this.pos;
        return super.read();
    }

    @Override
    public int read(byte[] cbuf, int off, int len) throws IOException {
        if (this.pos > this.maxSize) {
            return -1;
        }
        int read = super.read(cbuf, off, len);
        this.pos += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.pos > this.maxSize) {
            return -1L;
        }
        long skip = super.skip(n);
        this.pos += skip;
        return skip;
    }

    public long position() {
        return this.pos;
    }
}

