/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.raw;

import org.qubership.profiler.sax.values.ValueHolder;

public class TreeTraceVisitor {
    protected final int api;
    protected final TreeTraceVisitor tv;
    private long time;
    private int sp;

    public TreeTraceVisitor(int api) {
        this(api, null);
    }

    public TreeTraceVisitor(int api, TreeTraceVisitor tv) {
        this.api = api;
        this.tv = tv;
    }

    public void visitEnter(int methodId) {
        ++this.sp;
        if (this.tv != null) {
            this.tv.visitEnter(methodId);
        }
    }

    public void visitEnter(int methodId, long lastAssemblyId, long lastParentAssemblyId, byte isReactorEndPoint, byte isReactorFrame, long reactStartTime, int reactDuration, int blockingOperator, int prevOperation, int currentOperation, int emit) {
        ++this.sp;
        if (this.tv != null) {
            this.tv.visitEnter(methodId, lastAssemblyId, lastParentAssemblyId, isReactorEndPoint, isReactorFrame, reactStartTime, reactDuration, blockingOperator, prevOperation, currentOperation, emit);
        }
    }

    public void visitExit() {
        if (this.tv != null) {
            this.tv.visitExit();
        }
        --this.sp;
    }

    public void visitLabel(int labelId, ValueHolder value) {
        if (this.tv != null) {
            this.tv.visitLabel(labelId, value);
        }
    }

    public void visitLabel(int labelId, ValueHolder value, long assemblyId) {
        if (this.tv != null) {
            this.tv.visitLabel(labelId, value, assemblyId);
        }
    }

    public void visitTimeAdvance(long timeAdvance) {
        this.time += timeAdvance;
        if (this.tv != null) {
            this.tv.visitTimeAdvance(timeAdvance);
        }
    }

    public void visitEnd() {
        if (this.tv != null) {
            this.tv.visitEnd();
        }
    }

    public int getSp() {
        return this.sp;
    }

    public long getTime() {
        return this.time;
    }

    public TreeTraceVisitor asSkipVisitEnd() {
        return new TreeTraceVisitor(this.api, this){

            @Override
            public void visitEnd() {
            }

            @Override
            public TreeTraceVisitor asSkipVisitEnd() {
                return this;
            }
        };
    }
}

