/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.io.IOException;
import org.qubership.profiler.dump.IDataInputStreamEx;
import org.qubership.profiler.io.IPhraseInputStreamParser;
import org.qubership.profiler.sax.raw.ISuspendLogVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendPhraseReader
implements IPhraseInputStreamParser {
    private static final Logger logger = LoggerFactory.getLogger(SuspendPhraseReader.class);
    private ISuspendLogVisitor visitor;
    private IDataInputStreamEx is;
    private long time;
    private int dt;
    private int delay;

    public SuspendPhraseReader(IDataInputStreamEx dataInputStreamEx, ISuspendLogVisitor visitor) {
        this.visitor = visitor;
        this.is = dataInputStreamEx;
    }

    private void initTime() throws IOException {
        if (this.time == 0L) {
            this.time = this.is.readLong();
        }
    }

    public void parsingPhrases(int lenOfPhraseToRead, boolean parseUntilEOF, long begin, long end) throws IOException {
        boolean isTraceEnabled = logger.isTraceEnabled();
        int numberOfBytesToRemain = this.is.available() - lenOfPhraseToRead;
        this.initTime();
        while (this.is.available() > numberOfBytesToRemain || parseUntilEOF) {
            this.dt = this.is.readVarInt();
            this.delay = this.is.readVarInt();
            this.time += (long)this.dt;
            if (this.time < begin) continue;
            if (this.time - (long)this.delay > end) break;
            if (isTraceEnabled) {
                logger.trace("time: {}, delay: {}, delta_time: {}", new Object[]{this.time, this.delay, this.dt});
            }
            this.visitor.visitHiccup(this.time, this.delay);
        }
    }

    @Override
    public void parsingPhrases(int lenOfPhraseToRead, boolean parseUntilEOF) throws IOException {
        this.parsingPhrases(lenOfPhraseToRead, parseUntilEOF, Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

