/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.analyzer;

import com.netcracker.profiler.dom.ClobValues;
import com.netcracker.profiler.dom.ProfiledTree;
import com.netcracker.profiler.dom.ProfiledTreeStreamVisitor;
import com.netcracker.profiler.dom.TagDictionary;
import com.netcracker.profiler.io.Hotspot;
import com.netcracker.profiler.sax.stack.DumpVisitor;
import com.netcracker.profiler.sax.stack.DumpsVisitor;
import com.netcracker.profiler.threaddump.parser.ThreadInfo;
import com.netcracker.profiler.threaddump.parser.ThreaddumpParser;
import java.util.ArrayList;

public class AggregateThreadStacks
extends DumpsVisitor {
    private final ProfiledTreeStreamVisitor sv;
    private TagDictionary dict = new TagDictionary(100);
    private int dumps;
    private int threads;

    public AggregateThreadStacks(ProfiledTreeStreamVisitor sv) {
        this(1, sv);
    }

    protected AggregateThreadStacks(int api, ProfiledTreeStreamVisitor sv) {
        super(api);
        this.sv = sv;
    }

    @Override
    public DumpVisitor visitDump() {
        ++this.dumps;
        return new DumpVisitor(1){
            ProfiledTree tree;
            {
                this.tree = new ProfiledTree(AggregateThreadStacks.this.dict, new ClobValues());
            }

            @Override
            public void visitThread(ThreadInfo thread) {
                AggregateThreadStacks.this.threads++;
                Hotspot hs = this.tree.getRoot();
                int j = 0;
                ArrayList<ThreaddumpParser.ThreadLineInfo> trace = thread.stackTrace;
                for (int i = trace.size() - 1; i >= j; --i) {
                    ThreaddumpParser.ThreadLineInfo line = trace.get(i);
                    int id = AggregateThreadStacks.this.dict.resolve(line.toString());
                    hs = hs.getOrCreateChild(id);
                    ++hs.totalTime;
                    ++hs.childTime;
                }
                --hs.childTime;
            }

            @Override
            public void visitEnd() {
                AggregateThreadStacks.this.sv.visitTree(this.tree);
            }
        };
    }

    @Override
    public void visitEnd() {
        this.sv.visitEnd();
    }
}

