/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.dom;

import com.netcracker.profiler.dom.ClobValues;
import com.netcracker.profiler.dom.GanttInfo;
import com.netcracker.profiler.dom.TagDictionary;
import com.netcracker.profiler.io.Hotspot;
import com.netcracker.profiler.sax.raw.TreeRowid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProfiledTree {
    private Hotspot root = new Hotspot(-1);
    public List<GanttInfo> ganttInfos = new ArrayList<GanttInfo>();
    private TagDictionary dict;
    private ClobValues clobValues;
    private boolean ownDict = false;
    private TreeRowid rowid = TreeRowid.UNDEFINED;

    public ProfiledTree(TagDictionary dict, ClobValues clobValues) {
        this.dict = dict;
        this.clobValues = clobValues;
    }

    public ProfiledTree(TagDictionary dict, ClobValues clobValues, TreeRowid rowid) {
        this(dict, clobValues);
        this.rowid = rowid;
    }

    public Hotspot getRoot() {
        return this.root;
    }

    public TagDictionary getDict() {
        return this.dict;
    }

    public ClobValues getClobValues() {
        return this.clobValues;
    }

    public TreeRowid getRowid() {
        return this.rowid;
    }

    public void merge(ProfiledTree that) {
        if (this.dict != that.dict && !this.ownDict) {
            this.ownDict = true;
            this.dict = this.dict.clone();
        }
        if (!that.clobValues.getClobs().isEmpty()) {
            this.clobValues.merge(that.clobValues);
        }
        Map<Integer, Integer> remapIds = this.dict.merge(that.dict);
        that.root.remap(remapIds);
        if (this.root.id != that.root.id) {
            throw new IllegalArgumentException("Unable to merge two trees with different root ids: " + this.root.id + " and " + that.root.id);
        }
        if (this.ganttInfos == null) {
            this.ganttInfos = new ArrayList<GanttInfo>();
        }
        this.root.mergeWithChildren(that.root, this.ganttInfos);
        this.rowid = TreeRowid.UNDEFINED;
    }
}

