/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.dom;

import com.netcracker.profiler.configuration.ParameterInfoDto;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TagDictionary
implements Cloneable {
    private Map<String, Integer> map;
    private ArrayList<String> methods;
    private Map<String, ParameterInfoDto> paramInfo = new HashMap<String, ParameterInfoDto>();
    private BitSet ids = new BitSet();

    public TagDictionary() {
        this(10);
    }

    public TagDictionary(int size) {
        this.map = new HashMap<String, Integer>((int)((float)size / 0.75f));
        this.methods = new ArrayList(size);
    }

    public synchronized int resolve(String methodName) {
        Integer methodId = this.map.get(methodName);
        if (methodId != null) {
            return methodId;
        }
        return this.createEntry(methodName);
    }

    private synchronized int createEntry(String methodName) {
        Integer id = this.methods.size();
        this.methods.add(methodName);
        this.map.put(methodName, id);
        this.ids.set(id);
        return id;
    }

    public synchronized void put(int id, String name) {
        ArrayList<String> methods = this.methods;
        methods.ensureCapacity(id + 1);
        for (int i = methods.size(); i <= id; ++i) {
            methods.add(null);
        }
        methods.set(id, name);
        this.map.put(name, id);
        this.ids.set(id);
    }

    public TagDictionary clone() {
        try {
            TagDictionary clone = (TagDictionary)super.clone();
            clone.map.putAll(this.map);
            clone.methods.addAll(this.methods);
            clone.paramInfo.putAll(this.paramInfo);
            clone.ids.or(this.ids);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should be able to clone TagDictionary", e);
        }
    }

    public String resolve(int id) {
        return this.methods.get(id);
    }

    public BitSet getIds() {
        return this.ids;
    }

    public ArrayList<String> getTags() {
        return this.methods;
    }

    public Map<Integer, Integer> merge(TagDictionary that) {
        if (that == this) {
            return Collections.emptyMap();
        }
        for (ParameterInfoDto info : that.getParamInfo().values()) {
            this.info(info);
        }
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        ArrayList<String> tags = that.getTags();
        int ourTags = this.methods.size();
        for (int i = 0; i < tags.size(); ++i) {
            String s = tags.get(i);
            if (s == null || i < ourTags && s.equals(this.methods.get(i))) continue;
            int newId = this.resolve(s);
            remap.put(i, newId);
            this.ids.set(newId);
        }
        return remap;
    }

    public void info(ParameterInfoDto info) {
        this.paramInfo.put(info.name, info);
    }

    public Map<String, ParameterInfoDto> getParamInfo() {
        return this.paramInfo;
    }
}

