/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.io.ActivePODStreamReport;
import com.netcracker.profiler.io.HeapDumpInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ActivePODReport {
    String namespace;
    String serviceName;
    String podName;
    long activeSinceMillis = Long.MAX_VALUE;
    long firstSampleMillis = Long.MAX_VALUE;
    long lastSampleMillis = Long.MIN_VALUE;
    long dataAtStart = 0L;
    long dataAtEnd = 0L;
    Map<Long, Long> lastAndSecondLastData = new TreeMap<Long, Long>();
    Float currentBitrate = Float.valueOf(0.0f);
    List<DownloadOptions> downloadOptions = new ArrayList<DownloadOptions>();
    boolean onlineNow;
    List<HeapDumpInfo> heapDumps = new ArrayList<HeapDumpInfo>();

    public ActivePODReport(String podName) {
        this.podName = podName;
    }

    public void acceptActiveSinceStat(long statActiveSinceMillis) {
        this.activeSinceMillis = Math.min(this.activeSinceMillis, statActiveSinceMillis);
    }

    public void accepSampleMillis(long statSampleMIllis) {
        this.firstSampleMillis = Math.min(this.firstSampleMillis, statSampleMIllis);
        this.lastSampleMillis = Math.max(this.lastSampleMillis, statSampleMIllis);
    }

    public void acceptDataStat(long statDate, long statData) {
        this.dataAtStart = Math.min(this.dataAtStart, statData);
        this.dataAtEnd = Math.max(this.dataAtEnd, statData);
        this.lastAndSecondLastData.put(statDate, statData);
        while (this.lastAndSecondLastData.size() > 2) {
            this.lastAndSecondLastData.remove(this.lastAndSecondLastData.keySet().iterator().next());
        }
    }

    public void acceptStreamReport(ActivePODStreamReport streamReport) {
        this.activeSinceMillis = Math.min(this.activeSinceMillis, streamReport.activeSinceMillis);
        this.firstSampleMillis = Math.min(this.firstSampleMillis, streamReport.firstSampleMillis);
        this.lastSampleMillis = Math.max(this.lastSampleMillis, streamReport.lastSampleMillis);
        this.currentBitrate = Float.valueOf(this.currentBitrate.floatValue() + streamReport.currentBitrate.floatValue());
        if ("gc".equals(streamReport.streamName)) {
            this.downloadOptions.add(new DownloadOptions("gc", "/esc/download"));
        }
        if ("top".equals(streamReport.streamName)) {
            this.downloadOptions.add(new DownloadOptions("top", "/esc/download"));
        }
        if ("td".equals(streamReport.streamName)) {
            this.downloadOptions.add(new DownloadOptions("td", "/esc/download"));
        }
    }

    public void addGoProfileType(String type) {
        this.downloadOptions.add(new DownloadOptions(type, "/esc/v1/download"));
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public long getActiveSinceMillis() {
        return this.activeSinceMillis;
    }

    public void setActiveSinceMillis(long activeSinceMillis) {
        this.activeSinceMillis = activeSinceMillis;
    }

    public long getFirstSampleMillis() {
        return this.firstSampleMillis;
    }

    public void setFirstSampleMillis(long firstSampleMillis) {
        this.firstSampleMillis = firstSampleMillis;
    }

    public long getLastSampleMillis() {
        return this.lastSampleMillis;
    }

    public void setLastSampleMillis(long lastSampleMillis) {
        this.lastSampleMillis = lastSampleMillis;
    }

    public long getDataAtStart() {
        return this.dataAtStart;
    }

    public void setDataAtStart(long dataAtStart) {
        this.dataAtStart = dataAtStart;
    }

    public long getDataAtEnd() {
        return this.dataAtEnd;
    }

    public void setDataAtEnd(long dataAtEnd) {
        this.dataAtEnd = dataAtEnd;
    }

    public void addDataAtEnd(long dataAtEnd) {
        this.dataAtEnd += dataAtEnd;
    }

    public float getCurrentBitrate() {
        return this.currentBitrate.floatValue();
    }

    public void setCurrentBitrate(float currentBitrate) {
        this.currentBitrate = Float.valueOf(currentBitrate);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<HeapDumpInfo> getHeapDumps() {
        return this.heapDumps;
    }

    public void setHeapDumps(List<HeapDumpInfo> heapDumps) {
        this.heapDumps = heapDumps;
    }

    public boolean isOnlineNow() {
        return this.onlineNow;
    }

    public void setOnlineNow(boolean onlineNow) {
        this.onlineNow = onlineNow;
    }

    public List<DownloadOptions> getDownloadOptions() {
        return this.downloadOptions;
    }

    private static class DownloadOptions {
        String typeName;
        String uri;

        private DownloadOptions(String typeName, String uri) {
            this.typeName = typeName;
            this.uri = uri;
        }

        private String getTypeName() {
            return this.typeName;
        }

        private String getUri() {
            return this.uri;
        }
    }
}

