/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.configuration.ParameterInfoDto;
import com.netcracker.profiler.io.BigDedupParamKey;
import com.netcracker.profiler.io.BigParamKey;
import com.netcracker.profiler.io.Hotspot;
import com.netcracker.profiler.io.HotspotTag;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregatedCallTree {
    public final Hotspot root;
    public final Map<Integer, Hotspot> flatProfile;
    public List<String> tags;
    public final Map<String, ParameterInfoDto> paramInfo;
    public final Map<Integer, Map<Integer, String>> dedupParams;
    public final Map<Integer, Map<Integer, String>> bigParams;
    public final BitSet requredIds;
    private static final String UNMODIFIABLE_LIST_CLASS_NAME = Collections.unmodifiableList(Collections.emptyList()).getClass().getName();
    private Map<String, Object> dedupParamsMap;
    private Map<String, Integer> tagsMap;
    int nextDedupParamsOffset;

    public AggregatedCallTree(Hotspot root, Map<Integer, Hotspot> flatProfile, List<String> tags, Map<String, ParameterInfoDto> paramInfo, Map<Integer, Map<Integer, String>> dedupParams, Map<Integer, Map<Integer, String>> bigParams, BitSet requredIds) {
        this.root = root;
        this.flatProfile = flatProfile;
        this.tags = tags;
        this.paramInfo = paramInfo;
        this.dedupParams = dedupParams;
        this.bigParams = bigParams;
        this.requredIds = requredIds;
    }

    private void ensureMapsCreated() {
        int fileId;
        if (this.dedupParamsMap != null) {
            return;
        }
        HashMap<String, Object> dedupParamsMap = new HashMap<String, Object>();
        for (Map.Entry<Integer, Map<Integer, String>> entry : this.dedupParams.entrySet()) {
            fileId = entry.getKey();
            for (Map.Entry<Integer, String> value : entry.getValue().entrySet()) {
                dedupParamsMap.put(value.getValue(), new BigDedupParamKey(fileId, value.getKey().intValue()));
            }
        }
        for (Map.Entry<Integer, Map<Integer, String>> entry : this.bigParams.entrySet()) {
            fileId = entry.getKey();
            for (Map.Entry<Integer, String> value : entry.getValue().entrySet()) {
                dedupParamsMap.put(value.getValue(), new BigParamKey(fileId, value.getKey().intValue()));
            }
        }
        this.dedupParamsMap = dedupParamsMap;
        this.dedupParams.put(-1, new HashMap());
        if (UNMODIFIABLE_LIST_CLASS_NAME.equals(this.tags.getClass().getName())) {
            this.tags = new ArrayList<String>(this.tags);
        }
        HashMap<String, Integer> tagsMap = new HashMap<String, Integer>((int)((double)this.requredIds.cardinality() / 0.5));
        int i = -1;
        while ((i = this.requredIds.nextSetBit(i + 1)) >= 0) {
            String tag = this.tags.get(i);
            tagsMap.put(tag, i);
        }
        this.tagsMap = tagsMap;
    }

    public void merge(AggregatedCallTree tree) {
        this.ensureMapsCreated();
        this.remap(tree);
        if (this.root.id != tree.root.id) {
            throw new IllegalArgumentException("Unable to merge two trees with different root ids: " + this.root.id + " and " + tree.root.id);
        }
        this.root.mergeWithChildren(tree.root);
    }

    private void remap(AggregatedCallTree tree) {
        BigDedupParamKey key;
        String param;
        int fileId;
        Map<String, Integer> tagsMap = this.tagsMap;
        List<String> tags = this.tags;
        BitSet requiredIds = this.requredIds;
        HashMap<Integer, Integer> id2id = new HashMap<Integer, Integer>();
        BitSet treeIds = tree.requredIds;
        int i = -1;
        while ((i = treeIds.nextSetBit(i + 1)) >= 0) {
            String tag = tree.tags.get(i);
            if (tag == null) continue;
            Integer newTagId = tagsMap.get(tag);
            if (newTagId == null) {
                int tagsSize = tags.size();
                if (!requiredIds.get(i) && i < tagsSize) {
                    tags.set(i, tag);
                    requiredIds.set(i);
                    continue;
                }
                newTagId = tagsSize;
                tagsMap.put(tag, newTagId);
                requiredIds.set(newTagId);
                tags.add(tag);
            }
            if (newTagId == i) continue;
            id2id.put(i, newTagId);
        }
        Map<String, Object> dedupParamsMap = this.dedupParamsMap;
        Map<Integer, String> dedupParams = this.dedupParams.get(-1);
        HashMap<Object, Object> big2big = new HashMap<Object, Object>();
        for (Map.Entry<Integer, Map<Integer, String>> entry : tree.dedupParams.entrySet()) {
            fileId = entry.getKey();
            for (Map.Entry<Integer, String> value : entry.getValue().entrySet()) {
                param = value.getValue();
                Object newDedupParamKey = dedupParamsMap.get(param);
                if (newDedupParamKey == null) {
                    key = new BigDedupParamKey(-1, this.nextDedupParamsOffset++);
                    dedupParams.put(key.offset, param);
                    dedupParamsMap.put(param, key);
                    newDedupParamKey = key;
                }
                big2big.put(new BigDedupParamKey(fileId, value.getKey().intValue()), newDedupParamKey);
            }
        }
        for (Map.Entry<Integer, Map<Integer, String>> entry : tree.bigParams.entrySet()) {
            fileId = entry.getKey();
            for (Map.Entry<Integer, String> value : entry.getValue().entrySet()) {
                param = value.getValue();
                Object newBigParamKey = dedupParamsMap.get(param);
                if (newBigParamKey == null) {
                    key = new BigDedupParamKey(-1, this.nextDedupParamsOffset++);
                    dedupParams.put(key.offset, param);
                    dedupParamsMap.put(param, key);
                    newBigParamKey = key;
                }
                big2big.put(new BigParamKey(fileId, value.getKey().intValue()), newBigParamKey);
            }
        }
        Map<String, ParameterInfoDto> paramInfo = this.paramInfo;
        for (ParameterInfoDto info : tree.paramInfo.values()) {
            paramInfo.put(info.name, info);
        }
        this.remap(tree.root, id2id, big2big);
    }

    private void remap(Hotspot node, HashMap<Integer, Integer> id2id, HashMap big2big) {
        Map<HotspotTag, HotspotTag> tags;
        Integer newId = id2id.get(node.id);
        if (newId != null) {
            node.id = newId;
        }
        if (node.children != null) {
            for (Hotspot child : node.children) {
                this.remap(child, id2id, big2big);
            }
        }
        if ((tags = node.tags) == null || tags.isEmpty()) {
            return;
        }
        HashMap<HotspotTag, HotspotTag> newTags = new HashMap<HotspotTag, HotspotTag>();
        for (HotspotTag tag : tags.values()) {
            Object value;
            newId = id2id.get(tag.id);
            if (newId != null) {
                tag.id = newId;
            }
            if ((value = tag.value) instanceof BigDedupParamKey || value instanceof BigParamKey) {
                tag.value = big2big.get(value);
            }
            newTags.put(tag, tag);
        }
        node.tags = newTags;
    }
}

