/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.io.CallFilterer;
import com.netcracker.profiler.io.CallListener;
import com.netcracker.profiler.io.CallReaderFactory;
import com.netcracker.profiler.io.CallReaderFile;
import com.netcracker.profiler.io.ICallReader;
import com.netcracker.profiler.io.TemporalRequestParams;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"filestorage"})
public class CallReaderFactoryFile
implements CallReaderFactory {
    @Autowired
    ApplicationContext context;

    @Override
    public List<ICallReader> collectCallReaders(Map<String, String[]> params, TemporalRequestParams temporal, CallListener listener, CallFilterer filterer) throws IOException {
        return this.collectCallReaders(params, temporal, listener, filterer, null);
    }

    @Override
    public List<ICallReader> collectCallReaders(Map<String, String[]> params, TemporalRequestParams temporal, CallListener listener, CallFilterer filterer, Set<String> nodes) throws IOException {
        return this.collectCallReaders(params, temporal, listener, filterer, nodes, true);
    }

    @Override
    public List<ICallReader> collectCallReaders(Map<String, String[]> params, TemporalRequestParams temporal, CallListener listener, CallFilterer filterer, Set<String> nodes, boolean readDictionary) throws IOException {
        HashSet<String> dumpDirs = null;
        if (params != null) {
            String[] dumpDirsArr = params.get("dumpDirs");
            dumpDirs = dumpDirsArr == null ? null : new HashSet<String>(Arrays.asList(dumpDirsArr));
        }
        ICallReader cr = (ICallReader)this.context.getBean(CallReaderFile.class, new Object[]{listener, filterer, nodes, readDictionary, dumpDirs});
        long clientServerTimeDiff = (long)((double)Math.abs(temporal.clientUTC - temporal.serverUTC) * 1.5);
        cr.setTimeFilterCondition(temporal.timerangeFrom - clientServerTimeDiff, temporal.timerangeTo + clientServerTimeDiff);
        return Collections.singletonList(cr);
    }
}

