/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.chart.UnaryFunction;
import com.netcracker.profiler.configuration.ParameterInfoDto;
import com.netcracker.profiler.dump.DataInputStreamEx;
import com.netcracker.profiler.dump.DumperDetector;
import com.netcracker.profiler.io.Call;
import com.netcracker.profiler.io.CallFilterer;
import com.netcracker.profiler.io.CallListener;
import com.netcracker.profiler.io.CallReader;
import com.netcracker.profiler.io.DurationFilterer;
import com.netcracker.profiler.io.DurationParser;
import com.netcracker.profiler.io.ParamReader;
import com.netcracker.profiler.io.ParamReaderFactory;
import com.netcracker.profiler.io.SuspendLog;
import com.netcracker.profiler.sax.factory.SuspendLogFactory;
import com.netcracker.profiler.timeout.ProfilerTimeoutHandler;
import com.netcracker.profiler.utils.CommonUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CallReaderFile
extends CallReader {
    public static final boolean READ_CALL_RANGES = Boolean.parseBoolean(System.getProperty("com.netcracker.profiler.Profiler.READ_CALL_RANGES", "true"));
    public static final boolean READ_CALLS_DICTIONARY = Boolean.parseBoolean(System.getProperty("com.netcracker.profiler.Profiler.READ_CALLS_DICTIONARY", "true"));
    public static final boolean USE_FAST_CALL_READER = Boolean.parseBoolean(System.getProperty("profiler.USE_FAST_CALL_READER", "false"));
    public static final int CALLS_SCANNER_UPPER_BOUND_MINUTES = Integer.getInteger("profiler.CALLS_SCANNER_UPPER_BOUND_MINUTES", 60);
    private static final Logger logger = LoggerFactory.getLogger(CallReaderFile.class);
    @Value(value="${com.netcracker.profiler.DUMP_ROOT_LOCATION}")
    private File rootFile;
    @Autowired
    ParamReaderFactory paramReaderFactory;
    @Autowired
    SuspendLogFactory suspendLogFactory;
    private File inFlightRoot;
    private String inFlightRootPath;
    private Set<Call> inflightCalls;
    private String beginPath;
    private String endPath;
    private Set<String> nodes;
    private Set<String> dumpDirs;
    private boolean readDictionary = true;
    private long durationFrom = 0L;
    private long durationTo = Long.MAX_VALUE;
    private static final UnaryFunction<File, Long> CALLS_START_TIMESTAMP = new UnaryFunction<File, Long>(){

        @Override
        public Long evaluate(File file) {
            try {
                DataInputStreamEx calls = DataInputStreamEx.openDataInputStream((File)file);
                long time = calls.readLong();
                if ((int)(time >>> 32) == -66052) {
                    time = calls.readLong();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Timestamp of {} is {} ({})", new Object[]{file.getAbsolutePath(), new Date(time), time});
                }
                return time;
            }
            catch (EOFException e) {
                return System.currentTimeMillis();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Comparator<Long> LONG_COMPARATOR = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return o1.compareTo(o2);
        }
    };

    private CallReaderFile() {
        super(null, null);
        throw new RuntimeException("No-args not supported");
    }

    public CallReaderFile(CallListener callback, CallFilterer cf) {
        this(callback, cf, null);
    }

    public CallReaderFile(CallListener callback, CallFilterer cf, Set<String> nodes) {
        this(callback, cf, nodes, true);
    }

    public CallReaderFile(CallListener callback, CallFilterer cf, Set<String> nodes, boolean readDictionary) {
        this(callback, cf, nodes, readDictionary, null);
    }

    public CallReaderFile(CallListener callback, CallFilterer cf, Set<String> nodes, boolean readDictionary, Set<String> dumpDirs) {
        super(callback, cf);
        this.nodes = nodes;
        this.readDictionary = readDictionary;
        this.dumpDirs = dumpDirs;
        if (cf instanceof DurationFilterer) {
            DurationFilterer durationFilterer = (DurationFilterer)cf;
            this.durationFrom = durationFilterer.getDurationFrom();
            this.durationTo = durationFilterer.getDurationTo();
        }
    }

    @Override
    protected void innerFind() {
        Object[] inFlights = this.paramReaderFactory.getInstance(null).getInflightCalls();
        if (inFlights != null) {
            this.inFlightRoot = (File)inFlights[0];
            this.inFlightRootPath = this.inFlightRoot.getAbsolutePath();
            this.inflightCalls = new HashSet<Call>((List)inFlights[1]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("'" + File.separatorChar + "'yyyy'" + File.separatorChar + "'MM'" + File.separatorChar + "'dd");
        this.beginPath = this.begin == Long.MIN_VALUE ? null : sdf.format(this.begin) + File.separatorChar + this.begin;
        this.endPath = this.end == Long.MAX_VALUE ? null : sdf.format(this.end) + File.separatorChar + this.end;
        this.findInFolder(this.rootFile, "", 0);
        try {
            this.findInMemory();
        }
        catch (Exception e) {
            logger.error("Skipping inflight calls. Reason: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findCallsInFile(File root, SuspendLog suspendLog, ArrayList<Call> result, BitSet requiredIds, long endScan) {
        DataInputStreamEx callsStream = null;
        try {
            DataInputStreamEx calls = callsStream = DataInputStreamEx.openDataInputStream((File)root);
            boolean bl = this.findCallsInStream(calls, null, null, suspendLog, result, requiredIds, endScan);
            return bl;
        }
        catch (FileNotFoundException e) {
            this.exceptions.add(e);
        }
        catch (IOException e) {
            this.exceptions.add(e);
        }
        finally {
            this.close(callsStream);
        }
        return false;
    }

    private void close(DataInputStreamEx calls) {
        if (calls != null) {
            try {
                calls.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getJSReference(File dumpRoot) {
        String dumpDir = dumpRoot.getAbsolutePath();
        dumpRoot = dumpRoot.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        return dumpDir.substring(dumpRoot.getAbsolutePath().length() + 1);
    }

    private void findInFolder(File root, String currentPath, int level) {
        if (level != 0 && this.endPath != null && currentPath.compareTo(this.endPath) > 0) {
            return;
        }
        if (level == 1 && this.nodes != null && !this.nodes.contains(root.getName())) {
            return;
        }
        if (level == 5) {
            ArrayList<String> tags;
            SuspendLog suspendLog;
            if (this.dumpDirs != null && !this.dumpDirs.contains(root.getAbsolutePath()) && !this.dumpDirs.contains(this.getRelativePath(root))) {
                return;
            }
            if (!new File(root, "calls").exists()) {
                return;
            }
            try {
                suspendLog = this.suspendLogFactory.readMultiRangeSuspendLog(root.getAbsolutePath(), this.beginSuspendLog, this.endSuspendLog);
            }
            catch (IOException e) {
                suspendLog = SuspendLog.EMPTY;
                this.exceptions.add(e);
            }
            BitSet requiredIds = new BitSet();
            ParamReader paramReader = this.paramReaderFactory.getInstance(root.getAbsolutePath());
            Map<String, ParameterInfoDto> paramInfo = paramReader.fillParamInfo(this.exceptions, root.getAbsolutePath());
            boolean useCallsDictionary = false;
            File callsDictionaryFolder = new File(root, "callsDictionary");
            if (READ_CALLS_DICTIONARY && callsDictionaryFolder.exists()) {
                tags = paramReader.fillCallsTags(this.exceptions);
                useCallsDictionary = true;
            } else {
                tags = new ArrayList();
            }
            TreeMap<Long, File> callRangeFoldersMap = this.findCallRangeFolders(root);
            if (!READ_CALL_RANGES || callRangeFoldersMap.isEmpty() || this.durationFrom < callRangeFoldersMap.firstKey()) {
                File callsFolder = new File(root, "calls");
                if (!callsFolder.exists()) {
                    return;
                }
                long endScan = Long.MAX_VALUE;
                if (USE_FAST_CALL_READER && (endScan = this.end + (long)(CALLS_SCANNER_UPPER_BOUND_MINUTES * 60 * 1000)) < 0L) {
                    endScan = Long.MAX_VALUE;
                }
                this.findInCallsFolder(callsFolder, suspendLog, requiredIds, paramInfo, tags, root, endScan, paramReader, useCallsDictionary);
            } else {
                long endScan = Long.MAX_VALUE;
                long maxDuration = Long.MAX_VALUE;
                for (Map.Entry callsFolderEntry : callRangeFoldersMap.descendingMap().entrySet()) {
                    long minDuration = (Long)callsFolderEntry.getKey();
                    if (minDuration > this.durationTo) continue;
                    if (maxDuration < this.durationFrom) break;
                    File callsFolder = (File)callsFolderEntry.getValue();
                    this.findInCallsFolder(callsFolder, suspendLog, requiredIds, paramInfo, tags, root, endScan, paramReader, useCallsDictionary);
                    endScan = this.end + maxDuration;
                    if (endScan < 0L) {
                        endScan = Long.MAX_VALUE;
                    }
                    maxDuration = minDuration - 1L;
                }
            }
            this.callback.postProcess(this.getJSReference(root));
            return;
        }
        if (root.isDirectory()) {
            File[] files = root.listFiles(CALLS_FILE_FINDER);
            if (files == null) {
                return;
            }
            Arrays.sort(files, Collections.reverseOrder());
            String endPath = null;
            if (level == 0) {
                endPath = this.endPath;
            }
            for (File f : files) {
                String fileName = f.getName();
                if (level == 1 && fileName.length() != 4) continue;
                String nextPath = currentPath + File.separatorChar + fileName;
                if (level == 0) {
                    if (endPath != null) {
                        this.endPath = nextPath + endPath;
                    }
                    this.callBeginTime = Long.MAX_VALUE;
                    this.minCallBeginTime = Long.MAX_VALUE;
                }
                if (level > 0 && this.begin != Long.MIN_VALUE && this.minCallBeginTime < this.begin) break;
                this.findInFolder(f, nextPath, level + 1);
            }
        }
    }

    private TreeMap<Long, File> findCallRangeFolders(File root) {
        TreeMap<Long, File> callRangeFolders = new TreeMap<Long, File>();
        for (File file : root.listFiles()) {
            String startDurationStr;
            long minDuration;
            String fileName = file.getName();
            if (!fileName.startsWith("calls[")) continue;
            int delimiterPos = fileName.indexOf(45);
            if (delimiterPos == -1) {
                delimiterPos = fileName.indexOf(43);
            }
            if ((minDuration = DurationParser.parseDuration((String)(startDurationStr = fileName.substring(6, delimiterPos)), (long)-1L)) == -1L) {
                logger.error("Incorrect calls range folder " + fileName + ". Will skip scan of calls range files.");
                callRangeFolders.clear();
                return callRangeFolders;
            }
            callRangeFolders.put(minDuration, file);
        }
        return callRangeFolders;
    }

    private void findInCallsFolder(File callsFolder, SuspendLog suspendLog, BitSet requiredIds, Map<String, ParameterInfoDto> paramInfo, List<String> tags, File root, long endScan, ParamReader paramReader, boolean useCallsDictionary) {
        int startIdx;
        Object[] files = callsFolder.listFiles();
        Arrays.sort(files);
        ArrayList<Call> result = new ArrayList<Call>();
        int prevCardinality = requiredIds.cardinality();
        for (int i = startIdx = this.getStartFileIndexByStartTime((File[])files); i < files.length; ++i) {
            ProfilerTimeoutHandler.checkTimeout();
            Object f = files[i];
            String fileName = ((File)f).getName();
            if (fileName.length() != 6 && fileName.length() != 9) continue;
            result.clear();
            boolean stop = this.findCallsInFile((File)f, suspendLog, result, requiredIds, endScan);
            if (result.isEmpty()) {
                if (!stop) continue;
                break;
            }
            int newCardinality = requiredIds.cardinality();
            if (prevCardinality != newCardinality && this.readDictionary && !useCallsDictionary) {
                prevCardinality = newCardinality;
                tags.clear();
                tags.addAll(paramReader.fillTags(requiredIds, this.exceptions));
            }
            this.callDataReader.postCompute(result, tags, requiredIds);
            this.callback.processCalls(this.getJSReference(root), result, tags, paramInfo, requiredIds);
            if (stop) break;
        }
    }

    private int getStartFileIndexByStartTime(File[] files) {
        int from = CommonUtils.upperBound(files, this.begin, 0, files.length - 1, CALLS_START_TIMESTAMP, LONG_COMPARATOR);
        if (from == files.length) {
            --from;
        }
        from = Math.max(from, 0);
        return from;
    }

    private boolean checkDumper() {
        return DumperDetector.dumperActive();
    }

    private void findInMemory() {
        SuspendLog suspendLog;
        if (this.inflightCalls == null) {
            return;
        }
        if (!this.checkDumper()) {
            return;
        }
        ArrayList<Call> result = new ArrayList<Call>(this.inflightCalls.size());
        BitSet requiredIds = new BitSet();
        try {
            suspendLog = this.suspendLogFactory.readSuspendLog(this.inFlightRoot.getAbsolutePath());
        }
        catch (IOException e) {
            suspendLog = SuspendLog.EMPTY;
            this.exceptions.add(e);
        }
        for (Call call : this.inflightCalls) {
            if (this.cf != null && !this.cf.filter(call) || call.time > this.end || call.time + (long)call.duration < this.begin) continue;
            call.setSuspendDuration(suspendLog.getSuspendDuration(call.time, call.time + (long)call.duration));
            result.add(call);
            requiredIds.set(call.method);
            if (call.params == null) continue;
            for (Integer id : call.params.keySet()) {
                if (id <= 0) continue;
                requiredIds.set(id);
            }
        }
        if (result.isEmpty()) {
            return;
        }
        List<String> tags = this.paramReaderFactory.getInstance(this.inFlightRoot.getAbsolutePath()).fillTags(requiredIds, this.exceptions);
        Map<String, ParameterInfoDto> paramInfo = this.paramReaderFactory.getInstance(this.inFlightRoot.getAbsolutePath()).fillParamInfo(this.exceptions, this.inFlightRoot.getAbsolutePath());
        this.callback.processCalls(this.getJSReference(this.inFlightRoot), result, tags, paramInfo, requiredIds);
    }

    private String getRelativePath(File dumpDirFile) {
        return dumpDirFile.getAbsolutePath().substring(this.rootFile.getAbsolutePath().length() + 1);
    }
}

