/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import java.util.ArrayDeque;
import java.util.ArrayList;

public class FileNameUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static boolean isSpaceFileNameChar(char c) {
        return Character.isWhitespace(c) || c == '\"' || c == '\'';
    }

    public static String trimFileName(String fileName) {
        int st;
        if (fileName == null) {
            return null;
        }
        int len = fileName.length();
        for (st = 0; st < len && FileNameUtils.isSpaceFileNameChar(fileName.charAt(st)); ++st) {
        }
        while (st < len && FileNameUtils.isSpaceFileNameChar(fileName.charAt(len - 1))) {
            --len;
        }
        return fileName.substring(st, len);
    }

    public static boolean wildcardMatch(String fileName, String wildcardMatcher) {
        if (fileName == null && wildcardMatcher == null) {
            return true;
        }
        if (fileName != null && wildcardMatcher != null) {
            String[] wcs = FileNameUtils.splitOnTokens(wildcardMatcher);
            boolean anyChars = false;
            int textIdx = 0;
            int wcsIdx = 0;
            ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>(wcs.length);
            do {
                if (!backtrack.isEmpty()) {
                    int[] array = (int[])backtrack.pop();
                    wcsIdx = array[0];
                    textIdx = array[1];
                    anyChars = true;
                }
                while (wcsIdx < wcs.length) {
                    if (wcs[wcsIdx].equals("?")) {
                        if (++textIdx > fileName.length()) break;
                        anyChars = false;
                    } else if (wcs[wcsIdx].equals("*")) {
                        anyChars = true;
                        if (wcsIdx == wcs.length - 1) {
                            textIdx = fileName.length();
                        }
                    } else {
                        if (anyChars) {
                            if ((textIdx = FileNameUtils.checkIndexOf(fileName, textIdx, wcs[wcsIdx])) == -1) break;
                            int repeat = FileNameUtils.checkIndexOf(fileName, textIdx + 1, wcs[wcsIdx]);
                            if (repeat >= 0) {
                                backtrack.push(new int[]{wcsIdx, repeat});
                            }
                        } else if (!FileNameUtils.checkRegionMatches(fileName, textIdx, wcs[wcsIdx])) break;
                        textIdx += wcs[wcsIdx].length();
                        anyChars = false;
                    }
                    ++wcsIdx;
                }
                if (wcsIdx != wcs.length || textIdx != fileName.length()) continue;
                return true;
            } while (!backtrack.isEmpty());
            return false;
        }
        return false;
    }

    public static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int prevChar = 0;
        char[] var5 = array;
        int var6 = array.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            int ch = var5[var7];
            if (ch != 63 && ch != 42) {
                buffer.append((char)ch);
            } else {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == 63) {
                    list.add("?");
                } else if (prevChar != 42) {
                    list.add("*");
                }
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    private static int checkIndexOf(String str, int strStartIndex, String search) {
        int endIndex = str.length() - search.length();
        if (endIndex >= strStartIndex) {
            for (int i = strStartIndex; i <= endIndex; ++i) {
                if (!FileNameUtils.checkRegionMatches(str, i, search)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean checkRegionMatches(String str, int strStartIndex, String search) {
        return str.regionMatches(true, strStartIndex, search, 0, search.length());
    }
}

