/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.agent.Bootstrap;
import com.netcracker.profiler.agent.Configuration_01;
import com.netcracker.profiler.agent.DumperPlugin;
import com.netcracker.profiler.agent.DumperPlugin_01;
import com.netcracker.profiler.agent.ParameterInfo;
import com.netcracker.profiler.agent.ProfilerData;
import com.netcracker.profiler.agent.ProfilerTransformerPlugin;
import com.netcracker.profiler.configuration.ParameterInfoDto;
import com.netcracker.profiler.io.ParamReaderFile;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParamReaderFromMemory
extends ParamReaderFile {
    public ParamReaderFromMemory(File root) {
        super(root);
        Configuration_01.class.getName();
        DumperPlugin_01.class.getName();
    }

    @Override
    public Map<String, ParameterInfoDto> fillParamInfo(Collection<Throwable> exceptions, String rootReference) {
        if (this.canReadFromMemory(this.root)) {
            ProfilerTransformerPlugin transformer = (ProfilerTransformerPlugin)Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
            Configuration_01 conf = (Configuration_01)transformer.getConfiguration();
            Map infoMap = conf.getParametersInfo();
            HashMap<String, ParameterInfoDto> dtoMap = new HashMap<String, ParameterInfoDto>();
            for (Map.Entry entry : infoMap.entrySet()) {
                ParameterInfo info = (ParameterInfo)entry.getValue();
                ParameterInfoDto dto = new ParameterInfoDto(info.name);
                dto.big = info.big;
                dto.combined = info.combined;
                dto.deduplicate = info.deduplicate;
                dto.index = info.index;
                dto.list = info.list;
                dto.order = info.order;
                dto.signatureFunction = info.signatureFunction;
                dtoMap.put((String)entry.getKey(), dto);
            }
            return dtoMap;
        }
        return super.fillParamInfo(exceptions, rootReference);
    }

    @Override
    public List<String> fillTags(BitSet requredIds, Collection<Throwable> exceptions) {
        if (this.canReadFromMemory(this.root)) {
            return ProfilerData.getTags();
        }
        return super.fillTags(requredIds, exceptions);
    }

    private boolean canReadFromMemory(File root) {
        DumperPlugin_01 dumper = (DumperPlugin_01)Bootstrap.getPlugin(DumperPlugin.class);
        if (dumper == null) {
            return false;
        }
        File dumpRoot = dumper.getCurrentRoot();
        return dumpRoot != null && dumpRoot.getAbsolutePath().equals(root.getAbsolutePath());
    }
}

