/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.dump.DataInputStreamEx;
import com.netcracker.profiler.io.ReactorChainsResolver;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"filestorage"})
public class ReactorChainsResolverFile
extends ReactorChainsResolver {
    @Value(value="${com.netcracker.profiler.DUMP_ROOT_LOCATION}")
    private File rootFile;

    @Override
    protected DataInputStreamEx openReactorCallsStream(String folderName, int sequence) throws IOException {
        LinkedList<File> toTraverse = new LinkedList<File>();
        toTraverse.add(new File(this.rootFile, folderName));
        while (toTraverse.size() > 0) {
            File[] children;
            File cur = (File)toTraverse.pop();
            if (!cur.isDirectory() || ".".equals(cur.getName()) || "..".equals(cur.getName()) || (children = cur.listFiles()) == null) continue;
            if ("reactor_calls".equals(cur.getName())) {
                for (File f : children) {
                    String name;
                    if (!f.isFile() || !StringUtils.isNumeric((String)(name = StringUtils.replace((String)f.getName(), (String)".gz", (String)""))) || Integer.parseInt(name) != sequence) continue;
                    return DataInputStreamEx.openDataInputStream((File)f);
                }
                continue;
            }
            toTraverse.addAll(Arrays.asList(children));
        }
        return null;
    }
}

