/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io;

import com.netcracker.profiler.io.TemporalRequestParams;
import javax.servlet.http.HttpServletRequest;

public class TemporalUtils {
    public static TemporalRequestParams parseTemporal(HttpServletRequest request) {
        TemporalRequestParams result = new TemporalRequestParams();
        if ("last2min".equals(request.getParameter("last2MinOrRange"))) {
            result.timerangeFrom = System.currentTimeMillis() - 180000L;
            result.timerangeTo = System.currentTimeMillis();
        } else {
            result.timerangeFrom = TemporalUtils.parseLong(request, "timerange[min]", result.now - 900000L);
            result.timerangeTo = TemporalUtils.parseLong(request, "timerange[max]", result.now);
        }
        result.serverUTC = result.now = System.currentTimeMillis();
        result.clientUTC = TemporalUtils.parseLong(request, "clientUTC", result.serverUTC);
        result.autoUpdate = TemporalUtils.parseLong(request, "timerange[autoUpdate]", 1L);
        result.durationFrom = TemporalUtils.parseLong(request, "duration[min]", 500L);
        result.durationTo = TemporalUtils.parseLong(request, "duration[max]", Long.MAX_VALUE);
        return result;
    }

    public static long parseLong(HttpServletRequest request, String paramName, long defaultValue) throws IllegalArgumentException {
        String s = request.getParameter(paramName);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }
}

