/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io.aggregate;

import com.netcracker.profiler.io.Call;
import com.netcracker.profiler.io.aggregate.model.AggregateRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Aggregator {
    public static final long MAX_CALLS_FOR_AGGREGATE_TO_EXCEL;
    public static final long MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL;
    private Map<String, AggregateRow> rows = new HashMap<String, AggregateRow>();
    private long callsCount;

    public void processCall(Call call, String title) {
        if (this.callsCount >= MAX_CALLS_FOR_AGGREGATE_TO_EXCEL) {
            return;
        }
        ++this.callsCount;
        AggregateRow row = this.rows.get(title);
        if (row == null) {
            if ((long)this.rows.size() >= MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL) {
                return;
            }
            row = new AggregateRow();
            row.setTitle(title);
            this.rows.put(title, row);
        }
        row.setCount(row.getCount() + 1L);
        int currentDuration = call.duration + call.queueWaitDuration;
        row.setDuration((long)currentDuration + row.getDuration());
        row.getAllDurations().add(currentDuration);
        row.setCpuTime(call.cpuTime + row.getCpuTime());
        row.setQueueing((long)call.queueWaitDuration + row.getQueueing());
        row.setSuspension((long)call.suspendDuration + row.getSuspension());
        row.setMemory(call.memoryUsed + row.getMemory());
    }

    public Collection<AggregateRow> finish() {
        for (AggregateRow row : this.rows.values()) {
            long duration = row.getDuration();
            row.setDurationHours((double)duration / 1000.0 / 60.0 / 60.0);
            row.setDurationPerExec((double)duration / (double)row.getCount());
            row.setDuration90thPercentile(this.percentile(row.getAllDurations(), 90.0));
            long cpuTime = row.getCpuTime();
            row.setCpuTimeHours((double)cpuTime / 1000.0 / 60.0 / 60.0);
            row.setCpuTimePerExec((double)cpuTime / (double)row.getCount());
            long suspension = row.getSuspension();
            row.setSuspensionPerExec((double)suspension / (double)row.getCount());
            long memory = row.getMemory();
            row.setMemoryGb((double)memory / 1024.0 / 1024.0 / 1024.0);
            row.setMemoryPerExecMb((double)memory / (double)row.getCount() / 1024.0 / 1024.0);
        }
        if (this.callsCount >= MAX_CALLS_FOR_AGGREGATE_TO_EXCEL || (long)this.rows.size() >= MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL) {
            AggregateRow row;
            ArrayList<AggregateRow> result = new ArrayList<AggregateRow>(this.rows.values());
            row = new AggregateRow();
            if (this.callsCount >= MAX_CALLS_FOR_AGGREGATE_TO_EXCEL) {
                row.setTitle("MAX_CALLS_FOR_AGGREGATE_TO_EXCEL limit reached. Result is truncated. Narrow your selection or increase -Dcom.netcracker.profiler.agent.Profiler.MAX_CALLS_FOR_AGGREGATE_TO_EXCEL JVM arg.");
            } else {
                row.setTitle("MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL limit reached. Result is truncated. Adjust urlReplacePatterns or increase -Dcom.netcracker.profiler.agent.Profiler.MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL JVM arg.");
            }
            result.add(0, row);
            return result;
        }
        return this.rows.values();
    }

    private int percentile(List<Integer> durations, double percentile) {
        Collections.sort(durations);
        int index = (int)Math.ceil(percentile / 100.0 * (double)durations.size());
        return durations.get(index - 1);
    }

    static {
        long val = Long.getLong("com.netcracker.profiler.agent.Profiler.MAX_CALLS_FOR_AGGREGATE_TO_EXCEL", 10000000L);
        MAX_CALLS_FOR_AGGREGATE_TO_EXCEL = val == -1L ? Long.MAX_VALUE : val;
        val = Long.getLong("com.netcracker.profiler.agent.Profiler.MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL", 100000L);
        MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL = val == -1L ? Long.MAX_VALUE : val;
    }
}

