/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.io.searchconditions;

import com.netcracker.profiler.io.searchconditions.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LogicalCondition
implements Condition,
Cloneable {
    private List<Condition> conditions = new ArrayList<Condition>();
    private Operation operation;

    public LogicalCondition() {
    }

    public LogicalCondition(Operation op, Condition ... conditions) {
        this.conditions = Arrays.asList(conditions);
        this.operation = op;
    }

    public LogicalCondition(Operation op, List<Condition> conditions) {
        this.conditions = conditions;
        this.operation = op;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() == 0) {
            result.append("true[").append((Object)this.operation).append("]");
            return result.toString();
        }
        result.append("(");
        Iterator<Condition> it = this.conditions.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(" ").append((Object)this.operation);
        }
        result.append(")");
        return result.toString();
    }

    public static enum Operation {
        AND("and"),
        OR("or"),
        NOT("not");

        private String representation;

        private Operation(String representation) {
            this.representation = representation;
        }

        public static Operation from(String str) {
            for (Operation op : Operation.values()) {
                if (!op.representation.equalsIgnoreCase(str)) continue;
                return op;
            }
            throw new RuntimeException("Unknown operation " + str);
        }

        public String toString() {
            return this.representation;
        }
    }
}

