/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.sax.builders;

import com.netcracker.profiler.chart.Provider;
import com.netcracker.profiler.io.SuspendLog;
import com.netcracker.profiler.sax.raw.SuspendLogVisitor;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class SuspendLogBuilder
extends SuspendLogVisitor
implements Provider<SuspendLog> {
    private static int MAX_SIZE = 100000;
    protected SuspendLog log;
    protected long[] dates;
    protected int[] delays;
    protected int[] trueDelays;
    protected int size = 0;
    protected int maxSize;
    protected String rootReference;

    public SuspendLogBuilder(String rootReference) {
        this(1000, rootReference);
    }

    public SuspendLogBuilder(int size, String rootReference) {
        this(size, MAX_SIZE, rootReference);
    }

    public SuspendLogBuilder(int size, int maxSize, String rootReference) {
        this(1, size, maxSize, rootReference);
    }

    protected SuspendLogBuilder(int api, int size, int maxSize, String rootReference) {
        super(api);
        this.maxSize = maxSize;
        this.dates = new long[size];
        this.delays = new int[size];
        this.rootReference = rootReference;
    }

    @PostConstruct
    public void initLog() {
        this.log = new SuspendLog(new long[0], new int[0]);
    }

    @Override
    public void visitHiccup(long date, int delay) {
        this.ensureCapacity();
        this.dates[this.size] = date;
        this.delays[this.size] = delay;
        if (this.trueDelays != null) {
            this.trueDelays[this.size] = delay;
        }
        ++this.size;
    }

    @Override
    public void visitEnd() {
        if (this.dates.length != this.size) {
            this.realloc(this.size);
        }
        this.log.setValue(this.dates, this.delays, this.trueDelays);
    }

    private void ensureCapacity() {
        if (this.dates.length > this.size) {
            return;
        }
        if (2 * this.dates.length > this.maxSize && this.dates.length % 2 == 0) {
            this.compress();
            return;
        }
        this.realloc(this.dates.length * 2);
    }

    private void compress() {
        if (this.trueDelays == null) {
            this.trueDelays = new int[this.size];
            System.arraycopy(this.delays, 0, this.trueDelays, 0, this.size);
        }
        for (int i = 0; i < this.size / 2; ++i) {
            this.trueDelays[i] = this.trueDelays[2 * i] + this.trueDelays[2 * i + 1];
            this.delays[i] = (int)((long)this.delays[2 * i] + this.dates[2 * i + 1] - this.dates[2 * i]);
            this.dates[i] = this.dates[i * 2 + 1];
        }
        this.size /= 2;
    }

    private void realloc(int newSize) {
        long[] newDates = new long[newSize];
        int[] newDelays = new int[newSize];
        int min = Math.min(newSize, this.dates.length);
        System.arraycopy(this.dates, 0, newDates, 0, min);
        System.arraycopy(this.delays, 0, newDelays, 0, Math.min(newSize, this.delays.length));
        if (this.trueDelays != null) {
            int[] newTrueDelays = new int[newSize];
            System.arraycopy(this.trueDelays, 0, newTrueDelays, 0, Math.min(newSize, this.trueDelays.length));
            this.trueDelays = newTrueDelays;
        }
        this.dates = newDates;
        this.delays = newDelays;
    }

    @Override
    public SuspendLog get() {
        return this.log;
    }
}

