/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.sax.raw;

import com.netcracker.profiler.dump.DataInputStreamEx;
import com.netcracker.profiler.sax.raw.ClobReaderFlyweight;
import com.netcracker.profiler.sax.values.ClobValue;
import java.io.IOException;

public abstract class AbstractClobReaderFlyweight
implements ClobReaderFlyweight {
    private String currentFolder;
    private DataInputStreamEx is;
    private IOException ioException;
    private int fileIndex;
    private int length;
    private int startPosition;

    protected abstract DataInputStreamEx reopenDataInputStream(DataInputStreamEx var1, String var2, int var3) throws IOException;

    @Override
    public void adaptTo(ClobValue clob) {
        if (!clob.folder.equals(this.currentFolder) || clob.fileIndex != this.fileIndex || this.is != null && this.is.position() > clob.offset) {
            try {
                this.ioException = null;
                this.currentFolder = clob.folder;
                this.fileIndex = clob.fileIndex;
                this.is = this.reopenDataInputStream(this.is, clob.folder, clob.fileIndex);
            }
            catch (IOException e) {
                this.ioException = e;
                return;
            }
        }
        if (this.is == null) {
            this.ioException = new IOException("IllegalState: no input stream while adapting to clob " + String.valueOf(clob) + " in folder " + String.valueOf(this.currentFolder));
            return;
        }
        if (this.is.position() < clob.offset) {
            try {
                this.is.skipBytes(clob.offset - this.is.position());
            }
            catch (IOException e) {
                this.ioException = e;
            }
        }
        try {
            this.length = this.is.readVarInt();
        }
        catch (IOException e) {
            this.ioException = e;
        }
        this.startPosition = this.is.position();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (end > this.length) {
            throw new IOException("End index " + end + " exceeds charSequence length " + this.length);
        }
        if (start < 0) {
            throw new IOException("Start index " + start + " is negative");
        }
        if (end - start < 1) {
            return "";
        }
        int offset = this.startPosition - this.is.position() + start;
        if (offset < 0) {
            throw new IOException("Negative seeks not implemented. String start position: " + this.startPosition + ", stream position: " + this.is.position() + ", start: " + start + ", end: " + end);
        }
        this.is.skipBytes(offset * 2);
        char[] ary = new char[end - start];
        for (int i = 0; i < ary.length; ++i) {
            ary[i] = this.is.readChar();
        }
        return new String(ary);
    }

    public String toString() {
        return "ClobReaderFlyweightFile{currentFolder='" + this.currentFolder + '\'' + ", fileIndex=" + this.fileIndex + ", length=" + this.length + ", startPosition=" + this.startPosition + '}';
    }
}

