/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.sax.readers;

import com.netcracker.profiler.io.exceptions.ErrorSupervisor;
import com.netcracker.profiler.parsers.exception.ParserException;
import com.netcracker.profiler.sax.MethodIdBulder;
import com.netcracker.profiler.sax.raw.RepositoryVisitor;
import com.netcracker.profiler.sax.raw.TreeRowid;
import com.netcracker.profiler.sax.readers.HPROFLine;
import com.netcracker.profiler.sax.string.StringRepositoryAdapter;
import com.netcracker.profiler.sax.string.StringTraceAdapter;
import com.netcracker.profiler.sax.string.StringTreeTraceAdapter;
import java.io.BufferedReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbmsHprofReader {
    private static final Logger log = LoggerFactory.getLogger(DbmsHprofReader.class);
    private final RepositoryVisitor rv;

    public DbmsHprofReader(RepositoryVisitor rv) {
        this.rv = rv;
    }

    public void read(Reader reader, String name) {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            String s;
            StringRepositoryAdapter sra = new StringRepositoryAdapter(this.rv);
            StringTraceAdapter sta = sra.visitTrace();
            StringTreeTraceAdapter ttv = sta.visitTree(TreeRowid.UNDEFINED);
            MethodIdBulder idBuilder = new MethodIdBulder();
            HPROFLine line = new HPROFLine();
            long time = 0L;
            long prevMillis = 0L;
            while ((s = br.readLine()) != null) {
                if (s.startsWith("P#X ")) {
                    try {
                        long millis = (time += Long.parseLong(s.substring(4))) / 1000L;
                        if (millis == prevMillis) continue;
                        ttv.visitTimeAdvance(millis - prevMillis);
                        prevMillis = millis;
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse 'timer advance' line " + s, (Throwable)e);
                    }
                    continue;
                }
                if ("P#R".equals(s)) {
                    ttv.visitExit();
                    continue;
                }
                if (!s.startsWith("P#C")) continue;
                if (!line.init(s)) {
                    throw new ParserException("Cannot parse the following line in HPROF Dump: " + s);
                }
                ttv.visitEnter(line.buildId(idBuilder));
            }
            ttv.visitEnd();
            sta.visitEnd();
            sra.visitEnd();
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorSupervisor.getInstance().error("Unable to parse HPROF from " + name, t);
        }
    }
}

