/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.sax.readers;

import com.netcracker.profiler.sax.MethodIdBulder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HPROFLine {
    protected static final Pattern CALL_PATTERN = Pattern.compile("^P#C (PLSQL|SQL)\\.\"([^\"]*)\"\\.\"([^\"]*)\"(?:::([0-9]+))?\\.\"([^\"]*)\"(?:#([^ ]+))?(?: #(\\d+))?(?:\\.\"([^\\s]+)\")?");
    protected static final Map<String, String> OBJECT_TYPES = new HashMap<String, String>();
    public String namespace;
    public String schemaName;
    public String objectName;
    public String objectType;
    public String procedureName;
    public String overloadHashId;
    public int lineNumber;
    public String lineNumberString;
    public String sqlId;

    HPROFLine() {
    }

    public boolean init(CharSequence cs) {
        Matcher m = CALL_PATTERN.matcher(cs);
        if (!m.matches()) {
            return false;
        }
        this.namespace = m.group(1);
        this.schemaName = m.group(2);
        this.objectName = m.group(3);
        this.objectType = m.group(4);
        String type = OBJECT_TYPES.get(this.objectType);
        if (type != null) {
            this.objectType = type;
        }
        this.procedureName = m.group(5);
        this.overloadHashId = m.group(6);
        this.lineNumberString = m.group(7);
        this.lineNumber = this.lineNumberString != null ? Integer.parseInt(this.lineNumberString) : -1;
        this.sqlId = m.group(8);
        return true;
    }

    public String buildId(MethodIdBulder b) {
        if (b == null) {
            b = new MethodIdBulder();
        }
        String objectName = this.defaultIfEmpty(this.objectName, "no_object");
        String schemaName = this.defaultIfEmpty(this.schemaName, "no_schema");
        String objectType = this.defaultIfEmpty(this.objectType, "no_type");
        StringBuilder arguments = new StringBuilder();
        if (this.overloadHashId != null) {
            arguments.append("hash=").append(this.overloadHashId);
        }
        if (this.sqlId != null) {
            if (arguments.length() > 0) {
                arguments.append(", ");
            }
            arguments.append("sql_id=").append(this.sqlId);
        }
        return b.build(this.namespace + '.' + schemaName + '.' + objectType, objectName, this.procedureName, arguments.toString(), "void", objectName, this.lineNumberString, objectName);
    }

    private String defaultIfEmpty(String value, String defaultValue) {
        String objectName = value;
        if (objectName == null || objectName.length() == 0) {
            objectName = defaultValue;
        }
        return objectName;
    }

    static {
        OBJECT_TYPES.put("8", "FUNCTION");
        OBJECT_TYPES.put("11", "PACKAGE");
        OBJECT_TYPES.put("12", "TRIGGER");
    }
}

