/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.sax.readers;

import com.netcracker.profiler.dump.DataInputStreamEx;
import com.netcracker.profiler.io.ParamReader;
import com.netcracker.profiler.io.ParamReaderFactory;
import com.netcracker.profiler.sax.raw.ClobReaderFlyweight;
import com.netcracker.profiler.sax.raw.ClobReaderFlyweightFile;
import com.netcracker.profiler.sax.raw.RepositoryVisitor;
import com.netcracker.profiler.sax.raw.SuspendLogVisitor;
import com.netcracker.profiler.sax.readers.ProfilerTraceReader;
import com.netcracker.profiler.sax.readers.SuspendLogReader;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class ProfilerTraceReaderFile
extends ProfilerTraceReader {
    @Value(value="${com.netcracker.profiler.DUMP_ROOT_LOCATION}")
    File dumpRoot;
    @Autowired
    ParamReaderFactory paramReaderFactory;
    @Autowired
    ApplicationContext context;

    public ProfilerTraceReaderFile() {
    }

    private File dataFolder() {
        return new File(this.dumpRoot, this.rootReference);
    }

    public ProfilerTraceReaderFile(RepositoryVisitor rv, String rootReference) {
        super(rv, rootReference);
    }

    @Override
    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv, long begin, long end) {
        return (SuspendLogReader)this.context.getBean(SuspendLogReader.class, new Object[]{sv, this.dataFolder().getAbsolutePath(), begin, end});
    }

    @Override
    protected SuspendLogReader suspendLogReader(SuspendLogVisitor sv) {
        return this.suspendLogReader(sv, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public DataInputStreamEx reopenDataInputStream(DataInputStreamEx oldOne, String streamName, int traceFileIndex) throws IOException {
        return DataInputStreamEx.reopenDataInputStream((DataInputStreamEx)oldOne, (File)this.dataFolder(), (String)streamName, (int)traceFileIndex);
    }

    @Override
    public ClobReaderFlyweight clobReaderFlyweight() {
        ClobReaderFlyweightFile result = new ClobReaderFlyweightFile();
        result.setDataFolder(this.dataFolder());
        return result;
    }

    @Override
    protected ParamReader paramReader() {
        return this.paramReaderFactory.getInstance(this.dataFolder().getAbsolutePath());
    }
}

