/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.threaddump.parser;

import com.netcracker.profiler.threaddump.parser.ThreaddumpParser;

public class LockThreadLineInfo
implements ThreaddumpParser.ThreadLineInfo {
    public static final String TYPE_LOCKED = "locked";
    public static final String TYPE_WAIT = "waiting on";
    public static final String TYPE_ENTRY = "waiting to lock";
    public static final String TYPE_PARKING = "parking to wait for";
    public static final String TYPE_ELIMINATED = "eliminated";
    public String id;
    public String type;
    public String className;

    public String lookupType(String s) {
        if ((s = s.trim()).equals(TYPE_LOCKED)) {
            return TYPE_LOCKED;
        }
        if (s.equals(TYPE_WAIT)) {
            return TYPE_WAIT;
        }
        if (s.equals(TYPE_ENTRY)) {
            return TYPE_ENTRY;
        }
        if (s.equals(TYPE_PARKING)) {
            return TYPE_PARKING;
        }
        if (s.equals(TYPE_ELIMINATED)) {
            return TYPE_ELIMINATED;
        }
        return s + "(unknown)";
    }

    @Override
    public StringBuffer toJS(StringBuffer sb) {
        sb.append("new LockInfo('");
        sb.append(ThreaddumpParser.toJString(this.type)).append("\\000");
        sb.append(ThreaddumpParser.toJString(this.id)).append("\\000");
        sb.append(ThreaddumpParser.toJString(this.className));
        return sb.append("')\n");
    }

    @Override
    public boolean isLockLine(String className) {
        return this.className.equals(className);
    }

    @Override
    public boolean isMethodLine(String className, String methodName) {
        return false;
    }

    public String toString() {
        return "void " + this.className + "." + this.type + "() () []";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockThreadLineInfo that = (LockThreadLineInfo)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        return result;
    }
}

