/*
 * Decompiled with CFR 0.152.
 */
package com.netcracker.profiler.threaddump.parser;

import com.netcracker.profiler.threaddump.parser.ThreaddumpParser;

public class MethodThreadLineInfo
implements ThreaddumpParser.ThreadLineInfo {
    public String className;
    public String methodName;
    public String locationClass;
    public String locationLineNo;
    public String arguments;
    public String returnValue;

    @Override
    public StringBuffer toJS(StringBuffer sb) {
        sb.append("M.g('");
        sb.append(ThreaddumpParser.toJString(this.className)).append("\\000");
        sb.append(ThreaddumpParser.toJString(this.methodName)).append("\\000");
        sb.append(ThreaddumpParser.toJString(this.locationClass)).append("\\000");
        sb.append(ThreaddumpParser.toJString(this.locationLineNo));
        return sb.append("')\n");
    }

    @Override
    public boolean isLockLine(String className) {
        return false;
    }

    @Override
    public boolean isMethodLine(String className, String methodName) {
        return this.className.equals(className) && this.methodName.equals(methodName);
    }

    public String toString() {
        return (this.returnValue != null ? this.returnValue + ' ' : "void ") + this.className + "." + this.methodName + (this.arguments != null ? '(' + this.arguments + ") (" : "() (") + this.locationClass + ":" + this.locationLineNo + ") []";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodThreadLineInfo that = (MethodThreadLineInfo)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.locationClass != null ? !this.locationClass.equals(that.locationClass) : that.locationClass != null) {
            return false;
        }
        if (this.locationLineNo != null ? !this.locationLineNo.equals(that.locationLineNo) : that.locationLineNo != null) {
            return false;
        }
        return !(this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.locationClass != null ? this.locationClass.hashCode() : 0);
        result = 31 * result + (this.locationLineNo != null ? this.locationLineNo.hashCode() : 0);
        return result;
    }

    public void setClassName(String className) {
        if (className.startsWith("sun.reflect.GeneratedMethodAccessor")) {
            className = "sun.reflect.GeneratedMethodAccessor";
        } else if (className.startsWith("$Proxy")) {
            className = "Proxy";
        }
        this.className = className;
    }
}

