/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.Destination;
import javax.jms.Message;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;

public abstract class ActiveMQMessage
implements Message {
    public void dumpMessage$profiler() {
        String messageID = null;
        String correlationID = null;
        long timestamp = 0L;
        String groupID = null;
        String destination = null;
        String replyTo = null;
        try {
            Destination jmsReplyTo;
            messageID = this.getJMSMessageID();
            correlationID = this.getJMSCorrelationID();
            timestamp = this.getJMSTimestamp();
            groupID = this.getStringProperty("JMSXGroupID");
            Destination jmsDestination = this.getJMSDestination();
            if (jmsDestination != null) {
                destination = jmsDestination.toString();
            }
            if ((jmsReplyTo = this.getJMSReplyTo()) != null) {
                replyTo = jmsReplyTo.toString();
            }
        }
        catch (Throwable t) {
            Profiler.event((Object)StringUtils.throwableToString((Throwable)t), (String)"exception");
        }
        if (messageID != null && !messageID.isEmpty()) {
            Profiler.event((Object)messageID, (String)"jms.messageid");
        }
        if (correlationID != null && !correlationID.isEmpty()) {
            Profiler.event((Object)correlationID, (String)"jms.correlationid");
        }
        if (timestamp > 0L) {
            Profiler.event((Object)timestamp, (String)"jms.timestamp");
        }
        if (groupID != null && !groupID.isEmpty()) {
            Profiler.event((Object)groupID, (String)"jms.unitoforder");
        }
        if (destination != null && !destination.isEmpty()) {
            Profiler.event((Object)destination, (String)"jms.destination");
        }
        if (replyTo != null && !replyTo.isEmpty()) {
            Profiler.event((Object)replyTo, (String)"jms.replyto");
        }
    }
}

