/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.StringUtils;

public abstract class HornetQMessage
implements Message {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpMessage$profiler(HornetQMessage msg) {
        String destination = null;
        String replyTo = null;
        String messageId = null;
        String correlationId = null;
        long timestamp = 0L;
        String text = null;
        String textFragment = null;
        try {
            Destination replyDestination;
            Profiler.enter((String)"void org.hornetq.jms.client.HornetQMessage.dumpMessage$profiler(MessageListener,Message) (HornetQMessage.java:9) [unknown.jar]");
            Destination messageDestination = msg.getJMSDestination();
            if (messageDestination != null) {
                destination = messageDestination.toString();
            }
            if ((replyDestination = msg.getJMSReplyTo()) != null) {
                replyTo = replyDestination.toString();
            }
            messageId = msg.getJMSMessageID();
            correlationId = msg.getJMSCorrelationID();
            timestamp = msg.getJMSTimestamp();
            if (msg instanceof TextMessage && ProfilerData.LOG_JMS_TEXT) {
                TextMessage textMessage = (TextMessage)msg;
                text = textMessage.getText();
                if (text == null || text.length() <= 1500) {
                    textFragment = text;
                    text = null;
                } else {
                    textFragment = text.substring(0, 997) + "...";
                }
            }
        }
        catch (Throwable t) {
            Profiler.pluginException((Throwable)t);
        }
        finally {
            Profiler.exit();
        }
        Profiler.event(messageId, (String)"jms.messageid");
        Profiler.event(correlationId, (String)"jms.correlationid");
        Profiler.event((Object)replyTo, (String)"jms.replyto");
        if (timestamp != 0L) {
            Profiler.event((Object)new Long(timestamp), (String)"jms.timestamp");
        }
        if (destination != null) {
            Profiler.event((Object)destination, (String)"jms.destination");
            Profiler.getState().callInfo.setCliendId("JMS " + StringUtils.right((String)destination, (int)60));
        }
        Profiler.event(text, (String)"jms.text");
        Profiler.event(textFragment, (String)"jms.text.fragment");
    }
}

