/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.platform.scheduler.impl.jobs;

import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.qubership.profiler.agent.CallInfo;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;

public class AbstractJobImpl {
    protected void dumpContext$profiler(JobExecutionContext ctx) {
        String url;
        String jobMethod;
        JobDetail jobDetail = ctx.getJobDetail();
        Profiler.event((Object)jobDetail.getName(), (String)"job.id");
        JobDataMap map = jobDetail.getJobDataMap();
        CallInfo callInfo = Profiler.getState().callInfo;
        String name = (String)map.get("name");
        Profiler.event((Object)name, (String)"job.name");
        name = "Job " + name;
        callInfo.setModule(name);
        String action = null;
        Profiler.event(map.get("Action Type"), (String)"job.action.type");
        String jobClass = (String)map.get("Service Name");
        if (jobClass != null) {
            action = jobClass;
            Profiler.event((Object)jobClass, (String)"job.class");
        }
        if ((jobMethod = (String)map.get("Method")) != null) {
            action = action + '.' + jobMethod;
            Profiler.event((Object)jobMethod, (String)"job.method");
        }
        Profiler.event(map.get("JMS Connection Factory"), (String)"job.jms.connection.factory");
        String topic = (String)map.get("JMS Topic");
        if (topic != null) {
            action = topic;
            Profiler.event((Object)topic, (String)"job.jms.topic");
        }
        if ((url = (String)map.get("URL")) != null) {
            action = url;
            Profiler.event((Object)url, (String)"job.url");
        }
        if (action != null) {
            action = StringUtils.right((String)action, (int)32);
            callInfo.setAction(action);
        }
    }
}

