/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.regex.Pattern;
import javax.transaction.xa.Xid;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.MediationCallInfo;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;

public class CallInfo {
    public boolean corrupted;
    private String remoteAddress;
    private String requestURL;
    private String ncUser;
    private String endToEndId;
    private String traceId;
    public long transactions;
    public int logWritten;
    public int logGenerated;
    public long cpuTime;
    public long waitTime;
    public int queueWaitDuration;
    public long memoryUsed;
    public long fileRead;
    public long fileWritten;
    public long netRead;
    public long netWritten;
    public int finishTime;
    public volatile transient CallInfo next;
    public final boolean isFirstInThread;
    private transient MediationCallInfo mediationInfo;
    public int reactorDuration;
    public byte isPersist;
    public int additionalReportedTime = 0;
    public boolean isCallRed;
    public static final int MODULE_LENGTH = 48;
    public static final int ACTION_LENGTH = 32;
    public static final int CLIENT_ID_LENGTH = 64;
    public static final int CLIENT_INFO_LENGTH = 64;
    private String module = "";
    private String action = "";
    private String cliendId = "";
    private String clientInfo;
    private transient boolean anyFieldChanged;
    private transient boolean moduleChanged;
    private transient boolean actionChanged;
    private transient boolean cliendIdChanged;
    private transient boolean clientInfoChanged;
    private transient WeakReference<Connection> lastConnection;
    private transient WeakReference<Xid> lastXid;
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private static final Pattern INVALID_ICOMS_CHARS = Pattern.compile("[()\\[\\]{}$<>:]+");

    public CallInfo() {
        this.isFirstInThread = true;
    }

    public CallInfo(LocalState state) {
        this.isFirstInThread = state.callInfo == null;
        this.setClientInfo(state.shortThreadName);
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(String requestUrl) {
        this.requestURL = requestUrl;
    }

    public String getNcUser() {
        return this.ncUser;
    }

    public void setNcUser(String ncUser) {
        this.ncUser = ncUser;
    }

    public boolean checkConnection(Connection con) {
        if (this.lastConnection != null && con == this.lastConnection.get()) {
            return true;
        }
        this.lastConnection = new WeakReference<Connection>(con);
        return false;
    }

    public boolean sameXid(Xid xid) {
        if (this.lastXid != null && this.lastXid.get() == xid) {
            return true;
        }
        this.lastXid = new WeakReference<Xid>(xid);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean anyFieldChanged() {
        if (!this.anyFieldChanged) return false;
        this.anyFieldChanged = false;
        if (false) return false;
        return true;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        module = StringUtils.cap(module, 48);
        this.anyFieldChanged |= (this.moduleChanged |= StringUtils.stringDiffers(module, this.module));
        this.module = module;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean moduleChanged() {
        if (!this.moduleChanged) return false;
        this.moduleChanged = false;
        if (false) return false;
        return true;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        action = StringUtils.cap(action, 32);
        this.anyFieldChanged |= (this.moduleChanged |= (this.actionChanged |= StringUtils.stringDiffers(action, this.action)));
        this.action = action;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean actionChanged() {
        if (!this.actionChanged) return false;
        this.actionChanged = false;
        if (false) return false;
        return true;
    }

    public String getCliendId() {
        return this.cliendId;
    }

    public void setCliendId(String clientId) {
        clientId = StringUtils.cap(clientId, 64);
        this.anyFieldChanged |= (this.cliendIdChanged |= StringUtils.stringDiffers(clientId, this.cliendId));
        this.cliendId = clientId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean clientIdChanged() {
        if (!this.cliendIdChanged) return false;
        this.cliendIdChanged = false;
        if (false) return false;
        return true;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(String clientInfo) {
        clientInfo = StringUtils.cap(clientInfo, 64);
        this.anyFieldChanged |= (this.clientInfoChanged |= StringUtils.stringDiffers(clientInfo, this.clientInfo));
        this.clientInfo = clientInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean clientInfoChanged() {
        if (!this.clientInfoChanged) return false;
        this.clientInfoChanged = false;
        if (false) return false;
        return true;
    }

    public void setEndToEndId(String endToEndId) {
        endToEndId = SPACE.matcher(endToEndId).replaceAll("");
        endToEndId = INVALID_ICOMS_CHARS.matcher(endToEndId).replaceAll("");
        Profiler.event((Object)endToEndId, "end.to.end.id");
        this.endToEndId = endToEndId;
    }

    public String getEndToEndId() {
        return this.endToEndId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public MediationCallInfo getMediationInfo() {
        MediationCallInfo mediationInfo = this.mediationInfo;
        if (mediationInfo == null) {
            this.mediationInfo = mediationInfo = new MediationCallInfo();
        }
        return mediationInfo;
    }

    public void clean() {
        this.next = null;
        this.mediationInfo = null;
    }
}

