/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.util.Arrays;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.Profiler;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.agent.TimerCache;

public class LocalBuffer {
    public static final int SIZE = Integer.getInteger(LocalBuffer.class.getName() + ".SIZE", 4096);
    public volatile LocalState state;
    public LocalBuffer prevBuffer;
    public final long[] data = new long[SIZE];
    public final Object[] value = new Object[SIZE];
    public long startTime;
    public int count;
    public int first;
    public boolean corrupted;

    public LocalBuffer() {
        this.init(null);
    }

    public void init(LocalBuffer prevBuffer) {
        this.startTime = TimerCache.now;
        this.count = 0;
        this.first = 0;
        this.prevBuffer = prevBuffer;
    }

    public void event(Object contents, int tagId) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = (long)tagId | TimerCache.timerSHL32;
            this.value[r] = contents;
            this.count = r + 1;
        } else {
            LocalState state = this.state;
            Profiler.exchangeBuffer(this);
            state.buffer.event(contents, tagId);
        }
    }

    public void initEnter(int methodId) {
        this.initTimedEnter((long)methodId | TimerCache.timerSHL32);
    }

    public void initEnter(long methodAndTime) {
        this.initTimedEnter(methodAndTime);
    }

    public void initTimedEnter(long methodAndTime) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = methodAndTime;
            this.count = r + 1;
        } else {
            Profiler.exchangeBuffer(this, methodAndTime);
        }
    }

    public void initExit() {
        this.initTimedExit(TimerCache.timerSHL32);
    }

    public void initTimedExit(long time) {
        int r = this.count;
        long[] data = this.data;
        if (r >= 0 && r < data.length) {
            data[r] = time;
            this.count = r + 1;
        } else {
            Profiler.exchangeBuffer(this, time);
        }
    }

    public void reset() {
        if (this.first < this.count && this.first >= 0) {
            Arrays.fill(this.value, this.first, this.count, null);
        }
        this.first = 0;
        this.count = 0;
        this.prevBuffer = this;
        this.corrupted = false;
    }

    public String toString() {
        return "LocalBuffer{" + System.identityHashCode(this) + " corrupted=" + this.corrupted + ", state=" + System.identityHashCode(this.state) + ", count=" + this.count + ", first=" + this.first + ", startTime=" + this.startTime + ", data=" + StringUtils.arrayToString(new StringBuilder(), Arrays.copyOf(this.data, 20)) + ", value=" + StringUtils.arrayToString(new StringBuilder(), Arrays.copyOf(this.value, 20)) + ", prevBuffer=" + System.identityHashCode(this.prevBuffer) + '}';
    }

    public void command(byte commandId, Object result) {
        this.count = -1;
        this.data[0] = commandId;
        this.value[0] = result;
    }
}

