/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import org.qubership.profiler.agent.ESCLogger;
import org.w3c.dom.Element;

public class ParameterInfo {
    private static final ESCLogger logger = ESCLogger.getLogger(ParameterInfo.class);
    public final String name;
    public boolean big;
    public boolean deduplicate;
    public boolean index;
    public boolean list;
    public String signatureFunction;
    public int order = 1000;
    public int combined;

    public ParameterInfo(String name) {
        this.name = name;
        String lowerName = name.toLowerCase();
        if (lowerName.indexOf("sql") > -1 || lowerName.indexOf("xpath") > -1) {
            this.deduplicate = true;
            this.big = true;
        } else if (lowerName.indexOf("xml") > -1) {
            this.big = true;
        }
        this.update();
    }

    public ParameterInfo(Element e) {
        this(e.getAttribute("name"));
    }

    public void parse(Element e) {
        String orderNumber;
        String shouldList;
        String shouldIndex;
        String isBig = e.getAttribute("big");
        if (isBig.length() > 0) {
            this.big = Boolean.valueOf(isBig);
        }
        if ((shouldIndex = e.getAttribute("index")).length() > 0) {
            this.index = Boolean.valueOf(shouldIndex);
        }
        this.list = (shouldList = e.getAttribute("list")).length() == 0 || Boolean.valueOf(shouldList) != false;
        String dedup = e.getAttribute("deduplicate");
        if (dedup.length() > 0) {
            this.deduplicate = Boolean.valueOf(dedup);
            if (this.deduplicate) {
                this.big = true;
            }
        }
        if ((orderNumber = e.getAttribute("order")).length() == 0) {
            this.order = 100;
        } else {
            try {
                this.order = Integer.valueOf(orderNumber);
            }
            catch (NumberFormatException nfe) {
                logger.severe("[PROFILER] Unable to parse order attribute " + orderNumber, nfe);
            }
        }
        String signature = e.getAttribute("signature");
        if (signature.length() > 0) {
            this.signatureFunction = signature;
        }
        this.update();
    }

    public ParameterInfo index(boolean shouldIndex) {
        this.index = shouldIndex;
        this.update();
        return this;
    }

    public ParameterInfo big(boolean isBig) {
        this.big = isBig;
        this.update();
        return this;
    }

    public ParameterInfo deduplicate(boolean dedup) {
        this.deduplicate = dedup;
        this.update();
        return this;
    }

    public ParameterInfo list(boolean shouldList) {
        this.list = shouldList;
        this.update();
        return this;
    }

    public ParameterInfo order(int orderNumber) {
        this.order = orderNumber;
        this.update();
        return this;
    }

    public ParameterInfo signature(String signature) {
        this.signatureFunction = signature;
        return this;
    }

    public void update() {
        this.combined = this.big ? (this.deduplicate ? 3 : 1) : (this.index ? 2 : 0);
    }

    public ParameterInfo paramType(int type) {
        switch (type) {
            case 1: {
                this.big = true;
                this.deduplicate = false;
                this.index = false;
                break;
            }
            case 3: {
                this.big = true;
                this.deduplicate = true;
                this.index = false;
                break;
            }
            case 2: {
                this.big = false;
                this.deduplicate = false;
                this.index = true;
                break;
            }
            case 0: {
                this.big = false;
                this.deduplicate = false;
                this.index = true;
                break;
            }
            case 6: {
                this.big = false;
                this.deduplicate = false;
                this.index = false;
            }
        }
        this.combined = type;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterInfo)) {
            return false;
        }
        ParameterInfo that = (ParameterInfo)o;
        if (this.big != that.big) {
            return false;
        }
        if (this.combined != that.combined) {
            return false;
        }
        if (this.deduplicate != that.deduplicate) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.list != that.list) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.signatureFunction != null ? !this.signatureFunction.equals(that.signatureFunction) : that.signatureFunction != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.big ? 1 : 0);
        result = 31 * result + (this.deduplicate ? 1 : 0);
        result = 31 * result + (this.index ? 1 : 0);
        result = 31 * result + (this.list ? 1 : 0);
        result = 31 * result + this.order;
        result = 31 * result + this.combined;
        result = 31 * result + (this.signatureFunction != null ? this.signatureFunction.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ParameterInfo{name='" + this.name + '\'' + ", big=" + this.big + ", deduplicate=" + this.deduplicate + ", index=" + this.index + ", list=" + this.list + ", signatureFunction='" + this.signatureFunction + '\'' + ", order=" + this.order + ", combined=" + this.combined + '}';
    }
}

