/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.Configuration_03;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_02;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.LocalBuffer;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.Metric;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.agent.MetricsConfiguration;
import org.qubership.profiler.agent.MetricsPlugin;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.agent.ProfilerTransformerPlugin_01;
import org.qubership.profiler.agent.TimerCache;
import org.xml.sax.SAXException;

public class Profiler {
    private static final ESCLogger logger = ESCLogger.getLogger(Profiler.class);
    public static final String EXCHANGE_BUFFER_METHOD_NAME;
    public static final int EXCHANGE_BUFFER_METHOD_ID;

    private static void startDumper() {
        DumperPlugin_02 dumper;
        try {
            dumper = (DumperPlugin_02)Bootstrap.getPlugin(DumperPlugin.class);
            if (dumper == null) {
                logger.severe("[Profiler] Unable to find Dumper in the class path");
                return;
            }
        }
        catch (Throwable e) {
            logger.severe("[Profiler] Unable to find Dumper in the class path", e);
            return;
        }
        Profiler.enter("void " + Profiler.class.getName() + ".startDumper() (Profiler.java:20) [profiler-runtime.jar]");
        dumper.newDumper(ProfilerData.dirtyBuffers, ProfilerData.emptyBuffers, ProfilerData.activeThreads);
        ProfilerTransformerPlugin plugin = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
        ProfilerTransformerPlugin_01 transformerPlugin = (ProfilerTransformerPlugin_01)plugin;
        try {
            transformerPlugin.reloadClasses(null);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe("[Profiler] Unable to reload bootstrap classes", e);
        }
        Profiler.exit();
    }

    public static LocalState getState() {
        return ProfilerData.localState.get();
    }

    public static void event(Object value, String name) {
        if (value == null) {
            return;
        }
        Profiler.event(value, 0x3000000 | ProfilerData.resolveTag(name));
    }

    public static void event(Object value, int tagId) {
        Profiler.getState().event(value, tagId);
    }

    public static void pluginException(Throwable t) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.pluginError(t);
        }
    }

    public static void logError(String log) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.error(log);
        }
    }

    public static void logError(String log, Throwable t) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.error(log, t);
        }
    }

    public static void logWarn(String log) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.warn(log);
        }
    }

    public static void logWarn(String log, Throwable t) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.warn(log, t);
        }
    }

    public static void logInfo(String log) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.info(log);
        }
    }

    public static void logDebug(String log) {
        if (ProfilerData.pluginLogger != null) {
            ProfilerData.pluginLogger.debug(log);
        }
    }

    public static void enter(String methodName) {
        Profiler.enterWithDuration(methodName, -1L);
    }

    public static void enterWithDuration(String methodName, long millisecondsPassed) {
        int methodId = ProfilerData.resolveTag(methodName) | 0x1000000;
        Profiler.getState().enter(methodId, millisecondsPassed);
    }

    public static void enter(int methodId) {
        throw new RuntimeException("no longer supported");
    }

    public static LocalState enterReturning(int methodId) {
        LocalState state = Profiler.getState();
        state.enter(methodId);
        return state;
    }

    public static void exit() {
        Profiler.getState().exit();
    }

    public static void markSystem() {
        Profiler.getState().markSystem();
    }

    public static void threadExit() {
        LocalState state = Profiler.getState();
        if (ProfilerData.activeThreads.remove(state.thread) == null) {
            return;
        }
        ProfilerData.addDirtyBufferIfPossible(state.buffer);
    }

    public static void exchangeBuffer(LocalBuffer buffer) {
        LocalState state = buffer.state;
        if (state.isSystem || ProfilerData.dumperDead) {
            buffer.reset();
            return;
        }
        LocalBuffer newBuffer = ProfilerData.getEmptyBuffer(state);
        newBuffer.init(buffer);
        boolean bl = buffer.corrupted = !ProfilerData.addDirtyBuffer(buffer, ProfilerData.BLOCK_WHEN_DIRTY_BUFFERS_QUEUE_IS_FULL);
        if (buffer.corrupted) {
            buffer.reset();
            newBuffer.reset();
            ProfilerData.addEmptyBuffer(newBuffer);
            return;
        }
        int exchangeBegin = TimerCache.timer;
        state.buffer = newBuffer;
        int exchangeEnd = TimerCache.timer;
        int exchangeLength = exchangeEnd - exchangeBegin;
        if (exchangeLength > 0) {
            newBuffer.data[0] = (long)EXCHANGE_BUFFER_METHOD_ID | (long)exchangeBegin << 32;
            newBuffer.data[1] = (long)exchangeEnd << 32;
            newBuffer.count = 2;
        }
    }

    public static void exchangeBuffer(LocalBuffer buffer, long methodAndTime) {
        LocalState state = buffer.state;
        Profiler.exchangeBuffer(buffer);
        LocalBuffer newBuffer = state.buffer;
        long[] data = newBuffer.data;
        if (newBuffer.count > 0) {
            System.arraycopy(data, 0, data, 1, newBuffer.count);
        }
        data[0] = methodAndTime;
        ++newBuffer.count;
    }

    public static MetricsConfiguration getMetricConfigByName(String callType) {
        ProfilerTransformerPlugin transformer = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
        if (transformer == null) {
            logger.warning("ProfilerTransformerPlugin not loaded");
            return null;
        }
        Configuration_03 conf = (Configuration_03)transformer.getConfiguration();
        MetricsConfiguration result = null;
        for (MetricsConfiguration metricsConfiguration : conf.getMetricsConfig()) {
            if (!metricsConfiguration.getName().equals(callType)) continue;
            result = metricsConfiguration;
            break;
        }
        return result;
    }

    public static Metric getMetric(MetricType metricType, String callType, Map<String, String> aggregationParameters) {
        MetricsPlugin metricsPlugin = Bootstrap.getPlugin(MetricsPlugin.class);
        if (metricsPlugin == null) {
            logger.warning("MetricsPlugin not loaded");
            return null;
        }
        return metricsPlugin.getMetric(metricType, callType, aggregationParameters);
    }

    static {
        Profiler.startDumper();
        EXCHANGE_BUFFER_METHOD_NAME = "void " + Profiler.class.getName() + ".exchangeBuffer(" + LocalBuffer.class.getName() + ") (Profiler.java:81) [profiler-runtime.jar]";
        EXCHANGE_BUFFER_METHOD_ID = ProfilerData.resolveTag(EXCHANGE_BUFFER_METHOD_NAME) | 0x1000000;
    }
}

