/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.qubership.profiler.agent.LocalState;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.agent.ThreadJMXCpuProvider;
import org.qubership.profiler.agent.TimerCache;

public class ThreadJMXCpu
implements ThreadJMXCpuProvider {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    @Override
    public void updateThreadCounters(LocalState state) {
        int now = TimerCache.timer;
        if (now - state.nextCpuStamp < 0) {
            return;
        }
        state.cpuTime = threadMXBean.getThreadCpuTime(state.thread.getId()) / 1000000L;
        state.nextCpuStamp = now + ProfilerData.THREAD_CPU_MINIMAL_CALL_DURATION;
    }
}

