/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.analyzer;

import java.util.ArrayList;
import org.qubership.profiler.dom.ClobValues;
import org.qubership.profiler.dom.ProfiledTree;
import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.dom.TagDictionary;
import org.qubership.profiler.io.Hotspot;
import org.qubership.profiler.sax.stack.DumpVisitor;
import org.qubership.profiler.sax.stack.DumpsVisitor;
import org.qubership.profiler.threaddump.parser.ThreadInfo;
import org.qubership.profiler.threaddump.parser.ThreaddumpParser;

public class AggregateJFRStacks
extends DumpsVisitor {
    private final ProfiledTreeStreamVisitor sv;
    private TagDictionary dict = new TagDictionary(100);
    private int dumps;
    private int threads;

    public AggregateJFRStacks(ProfiledTreeStreamVisitor sv) {
        this(1, sv);
    }

    protected AggregateJFRStacks(int api, ProfiledTreeStreamVisitor sv) {
        super(api);
        this.sv = sv;
    }

    @Override
    public DumpVisitor visitDump() {
        ++this.dumps;
        return new DumpVisitor(1){
            ProfiledTree tree;
            {
                this.tree = new ProfiledTree(AggregateJFRStacks.this.dict, new ClobValues());
            }

            @Override
            public void visitThread(ThreadInfo thread) {
                AggregateJFRStacks.this.threads++;
                Hotspot hs = this.tree.getRoot();
                int j = 0;
                ArrayList<ThreaddumpParser.ThreadLineInfo> trace = thread.stackTrace;
                for (int i = trace.size() - 1; i >= j; --i) {
                    ThreaddumpParser.ThreadLineInfo line = trace.get(i);
                    int id = AggregateJFRStacks.this.dict.resolve(line.toString());
                    hs = hs.getOrCreateChild(id);
                    hs.totalTime += thread.value;
                    hs.childTime += thread.value;
                    ++hs.count;
                    ++hs.childCount;
                }
                hs.childTime -= thread.value;
                --hs.childCount;
            }

            @Override
            public void visitEnd() {
                AggregateJFRStacks.this.sv.visitTree(this.tree);
            }
        };
    }

    @Override
    public void visitEnd() {
        this.sv.visitEnd();
    }
}

