/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.chart;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.chart.UnaryFunction;
import org.qubership.profiler.io.JSHelper;

public class StackedChart {
    private final String title;
    private Map<String, TimeSeries> labels = new HashMap<String, TimeSeries>();

    public StackedChart(String title) {
        this.title = title;
    }

    public void add(long time, String label, int cnt) {
        TimeSeries series = this.getList(label);
        series.add(time, cnt);
    }

    private TimeSeries getList(String label) {
        TimeSeries series = this.labels.get(label);
        if (series == null) {
            series = new TimeSeries();
            this.labels.put(label, series);
        }
        return series;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public void toJS(Writer w) throws IOException {
        this.toJS(w, null);
    }

    public void toJS(Writer w, UnaryFunction<String, String> labelMapper) throws IOException {
        Map.Entry[] lines = this.labels.entrySet().toArray(new Map.Entry[this.labels.size()]);
        Arrays.sort(lines, new Comparator<Map.Entry<String, TimeSeries>>(){

            @Override
            public int compare(Map.Entry<String, TimeSeries> a, Map.Entry<String, TimeSeries> b) {
                long totalA = a.getValue().total;
                long totalB = b.getValue().total;
                if (totalA != totalB) {
                    return totalA > totalB ? 1 : -1;
                }
                return a.getKey().compareTo(b.getKey());
            }
        });
        w.append("{labels:[");
        int maxLines = lines.length;
        if (maxLines > 0) {
            w.append("\"Date\"");
        }
        for (Map.Entry line : lines) {
            w.append(',');
            w.append('\"');
            String label = (String)line.getKey();
            label = labelMapper != null ? labelMapper.evaluate(label) : JSHelper.escapeHTML(label);
            JSHelper.escapeJS(w, label);
            w.append('\"');
        }
        w.append("],\ntitle:\"");
        JSHelper.escapeJS(w, JSHelper.escapeHTML(this.title));
        w.append("\",\ndata:[");
        TimeSeries[] series = new TimeSeries[maxLines];
        for (int i = 0; i < lines.length; ++i) {
            series[i] = (TimeSeries)lines[i].getValue();
            series[i].end();
        }
        int[] it = new int[maxLines];
        boolean commaRequired = false;
        while (true) {
            TimeSeries line;
            int i;
            long now = Long.MAX_VALUE;
            for (i = 0; i < maxLines; ++i) {
                line = series[i];
                if (it[i] >= line.pos || line.dates[it[i]] >= now) continue;
                now = line.dates[it[i]];
            }
            if (now == Long.MAX_VALUE) break;
            if (commaRequired) {
                w.append("\n,");
            } else {
                commaRequired = true;
            }
            w.append("[new Date(");
            w.append(Long.toString(now));
            w.append(')');
            for (i = 0; i < maxLines; ++i) {
                line = series[i];
                w.append(',');
                if (it[i] < line.pos && line.dates[it[i]] == now) {
                    int val = line.values[it[i]];
                    w.append(Integer.toString(val));
                    int n = i;
                    it[n] = it[n] + 1;
                    continue;
                }
                w.append("null");
            }
            w.append(']');
        }
        w.append("]}");
    }

    public static class TimeSeries {
        int pos;
        long[] dates;
        int[] values;
        long total;
        long prevDate;

        public TimeSeries() {
            this(8);
        }

        public TimeSeries(int size) {
            this.dates = new long[size];
            this.values = new int[size];
        }

        public void add(long time, int value) {
            int pos = this.pos;
            this.ensureCapacity(pos);
            if (pos > 0 && time - this.prevDate > 1100L) {
                this.dates[pos] = this.prevDate + 1000L;
                this.values[pos] = 0;
                this.ensureCapacity(++pos);
            }
            this.prevDate = time;
            this.dates[pos] = time;
            this.values[pos] = value;
            this.total += (long)value;
            this.pos = pos + 1;
        }

        private void ensureCapacity(int pos) {
            if (this.dates.length > pos) {
                return;
            }
            long[] dates = new long[this.dates.length * 2];
            int[] values = new int[dates.length];
            System.arraycopy(this.dates, 0, dates, 0, this.dates.length);
            System.arraycopy(this.values, 0, values, 0, this.values.length);
            this.dates = dates;
            this.values = values;
        }

        public void end() {
            int pos = this.pos;
            if (pos == 0) {
                return;
            }
            this.add(this.dates[pos - 1] + 1000L, 0);
        }
    }
}

