/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.qubership.profiler.cli.ListServers;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.io.DurationParser;
import org.qubership.profiler.io.TemporalRequestParams;
import org.qubership.profiler.servlet.SpringBootInitializer;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.Namespace;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class ExportExcel
extends ListServers {
    public static final Logger log = LoggerFactory.getLogger(ExportExcel.class);
    public static final String DEFAULT_FILE_NAME = "esc_calls_startdate_enddate.xlsx";
    private long startDate;
    private long endDate;
    private String fileName;
    private List<String> selectedServers;
    private boolean aggregate;
    private int minDuration;
    private int minDigitsInId;
    private boolean disableDefaultUrlReplacePatterns;
    List<String> urlReplacePatterns;

    @Override
    public int accept(Namespace args) {
        this.setupDumpRoot(args);
        SpringBootInitializer.init();
        TimeZone tz = TimeZone.getTimeZone(args.getString("time_zone"));
        String endDateStr = args.getString("end_date");
        String startDateStr = args.getString("start_date");
        this.endDate = DurationParser.parseTimeInstant(endDateStr, Long.MAX_VALUE, Long.MAX_VALUE, tz);
        this.startDate = DurationParser.parseTimeInstant(startDateStr, Long.MAX_VALUE, this.endDate, tz);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        sdf.setTimeZone(tz);
        log.info("Exporting the data from {} to {}", (Object)sdf.format(new Date(this.startDate)), (Object)sdf.format(new Date(this.endDate)));
        long now = System.currentTimeMillis();
        if (this.startDate > now) {
            log.error("--start-date and --end-date are in the future. Please clarify the arguments and retry.");
            return -1;
        }
        this.fileName = args.getString("output_file");
        if (DEFAULT_FILE_NAME.equals(this.fileName)) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmm");
            this.fileName = "esc_calls_" + fmt.format(new Date(this.startDate)) + '_' + fmt.format(new Date(this.endDate)) + ".xlsx";
        }
        this.aggregate = args.getBoolean("aggregate");
        this.minDuration = args.getInt("min_duration");
        this.minDigitsInId = args.getInt("min_digits_in_id");
        this.disableDefaultUrlReplacePatterns = args.getBoolean("disable_default_url_replace_patterns");
        this.urlReplacePatterns = args.getList("url_replace_pattern");
        File file = new File(this.fileName);
        log.info("Will export results to {}", (Object)file.getAbsolutePath());
        this.selectedServers = args.getList("server");
        try {
            return this.runExport();
        }
        catch (IOException e) {
            log.error("Error while exporting data", e);
            return -1;
        }
    }

    private int runExport() throws IOException {
        System.setProperty("org.qubership.profiler.agent.Profiler.MAX_CALLS_FOR_AGGREGATE_TO_EXCEL", "-1");
        System.setProperty("org.qubership.profiler.agent.Profiler.MAX_DISTINCT_CALLS_FOR_AGGREGATE_TO_EXCEL", "-1");
        File dumpRoot = this.getDumpRoot();
        if (dumpRoot == null) {
            log.warn("No dump path found - {}. Please check path to ESC dump (--dump-root)", (Object)DumpRootResolver.dumpRoot);
            return -2;
        }
        try (FileOutputStream os = new FileOutputStream(this.fileName);){
            log.info("Exporting data from {}", (Object)dumpRoot.getAbsolutePath());
            long now = System.currentTimeMillis();
            TemporalRequestParams temporal = new TemporalRequestParams(now, now, now, this.startDate, this.endDate, 1L, this.minDuration, Long.MAX_VALUE);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("type", new String[]{this.aggregate ? "aggregate" : "all"});
            params.put("minDigitsInId", new String[]{String.valueOf(this.minDigitsInId)});
            params.put("urlReplacePatterns", this.urlReplacePatterns == null ? null : this.urlReplacePatterns.toArray(new String[0]));
            params.put("disableDefaultUrlReplacePatterns", new String[]{String.valueOf(this.disableDefaultUrlReplacePatterns)});
            params.put("nodes", this.selectedServers == null ? null : this.selectedServers.toArray(new String[0]));
            SpringBootInitializer.excelExporter().export(temporal, params, os);
        }
        catch (FileNotFoundException e) {
            log.error("Unable to open output file " + this.fileName, e);
            throw e;
        }
        return 0;
    }
}

