/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cloud.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import org.qubership.profiler.cloud.transport.ESCStopWatch;
import org.qubership.profiler.cloud.transport.ProfilerProtocolException;
import org.qubership.profiler.cloud.transport.WatchDogCallback;

public class FieldIO {
    boolean traceMode = false;
    public static ThreadLocal<ESCStopWatch> stopWatch = new ThreadLocal();
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private WatchDogCallback watchDog;
    private boolean currentCallWrites = false;
    private ByteBuffer buffer = ByteBuffer.allocate(1024);
    private byte[] array = this.buffer.array();

    public FieldIO(Socket socket, InputStream in, OutputStream out) {
        this.socket = socket;
        this.in = in;
        this.out = out;
    }

    public FieldIO(Socket socket, InputStream in, OutputStream out, WatchDogCallback watchDog) {
        this(socket, in, out);
        this.watchDog = watchDog;
    }

    private void startCall(boolean write) {
        ESCStopWatch.getWatch(stopWatch).start();
        this.currentCallWrites = write;
    }

    private void endCall() {
        ESCStopWatch.getWatch(stopWatch).stop();
        if (!this.currentCallWrites && this.watchDog != null) {
            this.watchDog.accessed();
        }
    }

    private void clearBuffer() {
        ((Buffer)this.buffer).clear();
    }

    private void readNumBytes(int numBytes) throws IOException {
        this.startCall(false);
        int numRead = 0;
        while (numRead != numBytes) {
            if (numBytes < numRead) {
                throw new ProfilerProtocolException("Read more than requested. Requested: " + numBytes + ". Read: " + numRead);
            }
            if (Thread.interrupted()) {
                throw new ProfilerProtocolException("Interrupted");
            }
            int numJustRead = this.in.read(this.array, numRead, numBytes - numRead);
            if (numJustRead > 0) {
                numRead += numJustRead;
                continue;
            }
            if (this.socket.isClosed() || this.socket.isInputShutdown() || !this.socket.isConnected() || !this.socket.isBound()) {
                throw new ProfilerProtocolException("Failed to read " + numBytes + " from socket. Only " + numRead + " have been read");
            }
            LockSupport.parkNanos(500000L);
        }
        this.endCall();
    }

    public void writeField(byte[] toWrite, int offset, int lenght) throws IOException {
        this.startCall(true);
        if (this.traceMode) {
            System.out.println("Writing field. Length is " + lenght);
        }
        this.buffer.putInt(0, lenght);
        this.out.write(this.buffer.array(), 0, 4);
        this.out.write(toWrite, offset, lenght);
        this.endCall();
    }

    public int readField() throws IOException {
        this.startCall(false);
        this.clearBuffer();
        this.readNumBytes(4);
        int lenght = this.buffer.getInt(0);
        if (lenght > this.array.length) {
            throw this.reportError("requested length of field " + lenght + " exceeds max lenght of " + this.array.length);
        }
        this.readNumBytes(lenght);
        if (this.traceMode) {
            System.out.println("Reading field. Length: " + lenght);
        }
        this.endCall();
        return lenght;
    }

    public String readString() throws IOException {
        int stringLenght = this.readField();
        return new String(this.buffer.array(), 0, stringLenght, StandardCharsets.UTF_8);
    }

    public void writeString(String toWrite) throws IOException {
        byte[] bytes = toWrite.getBytes(StandardCharsets.UTF_8);
        this.writeField(bytes, 0, bytes.length);
    }

    public long readLong() throws IOException {
        this.readNumBytes(8);
        long result = this.buffer.getLong(0);
        if (this.traceMode) {
            System.out.println("Read long " + result);
        }
        return result;
    }

    public int readInt() throws IOException {
        this.readNumBytes(4);
        int result = this.buffer.getInt(0);
        if (this.traceMode) {
            System.out.println("Read int " + result);
        }
        return result;
    }

    public void writeLong(long toWrite) throws IOException {
        this.startCall(true);
        this.clearBuffer();
        this.buffer.putLong(toWrite);
        this.out.write(this.array, 0, 8);
        if (this.traceMode) {
            System.out.println("Written long " + toWrite);
        }
        this.endCall();
    }

    public void writeInt(int toWrite) throws IOException {
        this.startCall(true);
        this.clearBuffer();
        this.buffer.putInt(toWrite);
        this.out.write(this.array, 0, 4);
        if (this.traceMode) {
            System.out.println("Written int " + toWrite);
        }
        this.endCall();
    }

    public UUID readUUID() throws IOException {
        long msb = this.readLong();
        long lsb = this.readLong();
        if (msb == 0L && lsb == 0L) {
            return null;
        }
        return new UUID(msb, lsb);
    }

    public void writeUUID(UUID toWrite) throws IOException {
        if (toWrite == null) {
            this.writeLong(0L);
            this.writeLong(0L);
        } else {
            long msb = toWrite.getMostSignificantBits();
            long lsb = toWrite.getLeastSignificantBits();
            this.writeLong(msb);
            this.writeLong(lsb);
        }
    }

    public byte[] getArray() {
        return this.array;
    }

    public void writeCommand(int commandId) throws IOException {
        this.startCall(true);
        this.out.write(commandId);
        this.endCall();
    }

    public RuntimeException reportError(String message) {
        throw new ProfilerProtocolException(message);
    }
}

