/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.configuration.callfilters;

import java.util.BitSet;
import java.util.Map;
import org.qubership.profiler.agent.FilterOperator;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.dump.ThreadState;

public class FilterOperatorClassMethod
implements FilterOperator {
    private String className;
    private String methodName;
    private BitSet matchedCalls = new BitSet();
    private BitSet unmatchedCalls = new BitSet();

    public FilterOperatorClassMethod() {
    }

    public FilterOperatorClassMethod(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public boolean evaluate(Map<String, Object> params) {
        ThreadState threadState = (ThreadState)params.get("threadState");
        return this.checkClassMethodMatching(threadState);
    }

    private boolean checkClassMethodMatching(ThreadState threadState) {
        if (this.matchedCalls.get(threadState.method)) {
            return true;
        }
        if (this.unmatchedCalls.get(threadState.method)) {
            return false;
        }
        String callName = ProfilerData.resolveMethodId(threadState.method);
        callName = callName.substring(callName.indexOf(32) + 1);
        callName = callName.substring(0, callName.indexOf(40));
        String actualClassName = callName.substring(0, callName.lastIndexOf(46));
        String actualMethodName = callName.substring(callName.lastIndexOf(46) + 1);
        if (actualClassName.equals(this.className) && ("".equals(this.methodName) || actualMethodName.equals(this.methodName))) {
            this.matchedCalls.set(threadState.method);
            return true;
        }
        this.unmatchedCalls.set(threadState.method);
        return false;
    }
}

