/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class DumpFile {
    private static final Logger log = LoggerFactory.getLogger(DumpFile.class);
    public static final Collection<String> REMOVABLE_DIRS = Arrays.asList("trace", "xml", "calls", "sql");
    private final String path;
    private final String root;
    private final String parent;
    private final long size;
    private final long timestamp;
    private DumpFile dependentFile;

    public DumpFile(String path, long size, long timestamp, DumpFile dependentFile) throws NullPointerException {
        String rootDirName;
        if (path == null || path.length() == 0) {
            throw new NullPointerException("Parameter 'path' can't be null or empty");
        }
        this.path = path;
        File parent = new File(path).getParentFile();
        String parentDirName = parent.getName();
        File grandparent = parent.getParentFile();
        this.root = rootDirName = grandparent.getName();
        this.parent = parentDirName;
        this.size = size;
        this.timestamp = timestamp;
        this.dependentFile = dependentFile;
    }

    public DumpFile(String path, long size, long timestamp) throws NullPointerException {
        this(path, size, timestamp, null);
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRootDirName() {
        return this.root;
    }

    public String getParentDirName() {
        return this.parent;
    }

    public String getDumpRootName() {
        return this.root;
    }

    public DumpFile getDependentFile() {
        return this.dependentFile;
    }

    public void setDependentFile(DumpFile dependentFile) {
        this.dependentFile = dependentFile;
    }

    public boolean delete() {
        File f = new File(this.path);
        log.info("Deleting file {}", (Object)f);
        return f.delete();
    }

    public String toString() {
        return "DumpFile{path='" + this.path + '\'' + ", size=" + this.size + ", timestamp=" + this.timestamp + ", dependentFile=" + this.dependentFile + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DumpFile dumpFile = (DumpFile)o;
        return this.path.equals(dumpFile.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

