/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;
import org.qubership.profiler.dump.DumpFile;
import org.qubership.profiler.shaded.org.apache.commons.lang.math.NumberUtils;

public class DumpFilesFinder {
    private static final FileFilter DIRECTORY_FINDER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static final Comparator<File> ORDER_BY_LAST_MODIFIED_ASC = new Comparator<File>(){

        @Override
        public int compare(File a, File b) {
            long compareResult = a.lastModified() - b.lastModified();
            return compareResult == 0L ? 0 : (compareResult > 0L ? 1 : -1);
        }
    };

    public Queue<DumpFile> search(String path) {
        if (path == null) {
            return null;
        }
        LinkedList<DumpFile> queue = new LinkedList<DumpFile>();
        this.findInFolder(new File(path), queue, 0);
        return queue;
    }

    private void findInFolder(File root, Queue<DumpFile> queueToFill, int level) {
        if (level == 4) {
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> sqlFiles = new ArrayList<File>();
            for (File child : root.listFiles()) {
                if ("sql".equals(child.getName())) {
                    this.addFiles(sqlFiles, child);
                } else {
                    this.addFiles(files, child);
                }
                this.deleteFolderIfEmpty(child);
            }
            Collections.sort(files, ORDER_BY_LAST_MODIFIED_ASC);
            Collections.sort(sqlFiles, ORDER_BY_LAST_MODIFIED_ASC);
            files.addAll(sqlFiles);
            for (File file : files) {
                DumpFile dumpFile = new DumpFile(file.getPath(), file.length(), file.lastModified());
                queueToFill.add(dumpFile);
            }
            this.deleteFolderIfEmpty(root);
            return;
        }
        if (root.isDirectory()) {
            if (level == 1 && !NumberUtils.isNumber(root.getName())) {
                return;
            }
            Object[] files = root.listFiles(DIRECTORY_FINDER);
            if (files.length == 0) {
                root.delete();
                return;
            }
            Arrays.sort(files);
            for (Object f : files) {
                this.findInFolder((File)f, queueToFill, level + 1);
            }
            this.deleteFolderIfEmpty(root);
        }
    }

    private void addFiles(ArrayList<File> files, File folder) {
        files.addAll(Arrays.asList(folder.listFiles()));
    }

    private boolean deleteFolderIfEmpty(File folder) {
        if (folder.listFiles().length == 0) {
            return folder.delete();
        }
        return false;
    }
}

