/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class DumperDetector {
    private static final Logger logger = LoggerFactory.getLogger(DumperDetector.class);
    private static boolean dumperAbsent;

    public static boolean dumperActive() {
        if (dumperAbsent) {
            return false;
        }
        try {
            Class<?> bootstrap = Class.forName("org.qubership.profiler.agent.Bootstrap");
            Class<?> dumperClass = Class.forName("org.qubership.profiler.agent.DumperPlugin");
            Method getPluginOrNull = bootstrap.getDeclaredMethod("getPlugin", Class.class);
            Object dumperPlugin10 = getPluginOrNull.invoke(null, dumperClass);
            if (dumperPlugin10 == null) {
                logger.debug("Bootstrap is present in the classpath, but dumper is not");
                return false;
            }
            Method isInitializedMethod = dumperPlugin10.getClass().getDeclaredMethod("isInitialized", new Class[0]);
            boolean result = (Boolean)isInitializedMethod.invoke(dumperPlugin10, new Object[0]);
            logger.debug("Dumper is present in the system. Active: {}", (Object)result);
            return result;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
            logger.debug("Dumper is either too old or absent", e);
            dumperAbsent = true;
            return false;
        }
    }
}

