/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.qubership.profiler.Dumper;
import org.qubership.profiler.IDumper;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.DumperPlugin;
import org.qubership.profiler.agent.DumperPlugin_07;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.cloud.transport.ProfilerProtocolException;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class DumperThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DumperThread.class);
    public static long DUMPER_RESTART_INTERVAL = TimeUnit.SECONDS.toMillis(Integer.getInteger(Dumper.class.getName() + ".RESTART_INTERVAL", 10).intValue());
    private final IDumper dumper;
    private volatile boolean shutdownRequested;
    public static volatile int dumperIncarnationWhenStarted = 0;
    private boolean remoteExceptionReported = false;
    final Thread SHUTDOWN_HOOK = new Thread(){

        @Override
        public void run() {
            DumperThread.this.shutdown();
        }
    };

    public DumperThread(IDumper dumper, String name) {
        super(name);
        this.dumper = dumper;
        this.setDaemon(true);
        log.debug("Starting dumper thread {}, version {}", (Object)name, (Object)Bootstrap.getImplementationVersion(this.getClass()));
        dumperIncarnationWhenStarted = ProfilerData.dumperIncarnation;
        this.start();
    }

    public void shutdown() {
        this.shutdownRequested = true;
        DumperPlugin dumper = Bootstrap.getPlugin(DumperPlugin.class);
        if (dumper != null && dumper instanceof DumperPlugin_07) {
            ((DumperPlugin_07)dumper).gracefulShutdown();
            return;
        }
        log.warn("Dumper does not support graceful shutdown, will just close the files");
        try {
            this.dumper.close();
        }
        catch (IOException e) {
            this.fatal("Unable to close dumper streams at shutdown", e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(this.SHUTDOWN_HOOK);
        while (!this.shutdownRequested) {
            block30: {
                if (ProfilerData.dumperIncarnation == DumperThread.dumperIncarnationWhenStarted) ** GOTO lbl21
                try {
                    Thread.sleep(DumperThread.DUMPER_RESTART_INTERVAL);
                    ** GOTO lbl21
                }
                catch (InterruptedException e) {
                    DumperThread.log.info("Interrupted while in delay between restarts");
                    this.interrupt();
                    if (this.dumper == null) return;
                    try {
                        this.dumper.close();
                        return;
                    }
                    catch (Throwable t) {
                        this.fatal("Error when closing dumper", t);
                    }
                    return;
                }
                {
                    catch (Throwable var3_13) {
                        throw var3_13;
                    }
lbl21:
                    // 2 sources

                    try {
                        this.dumper.initialize();
                        ProfilerData.dumperDead = false;
                        this.remoteExceptionReported = false;
                        ProfilerData.warnBufferQueueOverflow = true;
                    }
                    catch (ProfilerProtocolException e) {
                        ProfilerData.dumperDead = true;
                        if (this.shouldReportRemoteException()) {
                            this.notFatal("Unable to connect to remote collector", e);
                            this.remoteExceptionReported = true;
                        }
                        if (this.dumper != null) {
                            try {
                                this.dumper.close();
                            }
                            catch (Throwable t) {
                                this.fatal("Error when closing dumper", t);
                            }
                        }
                        break block30;
                    }
                    catch (Throwable t) {}
                    ** try [egrp 6[TRYBLOCK] [11 : 157->169)] { 
lbl41:
                    // 1 sources

                    ProfilerData.dumperDead = true;
                    this.fatal("Unable to initialize dumper", t);
                    break block30;
lbl44:
                    // 1 sources

                    finally {
                        if (this.dumper != null) {
                            try {
                                this.dumper.close();
                            }
                            catch (Throwable t) {
                                this.fatal("Error when closing dumper", t);
                            }
                        }
                    }
                }
                {
                    try {
                        this.dumper.dumpLoop();
                    }
                    catch (InterruptedException e) {
                        ProfilerData.dumperDead = true;
                        this.notFatal("interrupted dump loop", e);
                    }
                    catch (Throwable t) {
                        ProfilerData.dumperDead = true;
                        this.fatal("Error while dumping records", t);
                    }
                    if (this.dumper == null) break block30;
                }
                try {
                    this.dumper.close();
                }
                catch (Throwable t) {
                    this.fatal("Error when closing dumper", t);
                }
            }
            ++ProfilerData.dumperIncarnation;
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.SHUTDOWN_HOOK);
            return;
        }
        catch (IllegalStateException var1_8) {
            // empty catch block
        }
    }

    private boolean shouldReportRemoteException() {
        try {
            return !this.remoteExceptionReported || log.isDebugEnabled();
        }
        catch (Throwable t) {
            log.error("", t);
            return true;
        }
    }

    public void fatal(String message, Throwable t) {
        try {
            log.error(message, t);
        }
        catch (Throwable x) {
            try {
                System.err.println("[Profiler.DumperThread] Error writing to profiler.log");
                System.err.println(message);
                t.printStackTrace();
                x.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void notFatal(String message, Throwable t) {
        try {
            if (t == null) {
                log.info(message);
            } else if (log.isDebugEnabled()) {
                log.debug(message, t);
            } else {
                log.info(message + " " + t.getMessage());
            }
        }
        catch (Throwable x) {
            try {
                System.err.println("[Profiler.DumperThread] Error writing to profiler.log");
                System.err.println(message);
                if (t != null) {
                    t.printStackTrace();
                }
                x.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

